<?php

/**
 * Class ImportDataFactory
 */
class ImportDataFactory
{
    public static function createImporter(string $type): ImportDataInterface
    {
        $class = ucfirst($type) . 'Importer';
        $file = __DIR__ . '/implementations/' . $class . '.php';
        if (file_exists($file) && (include_once $file)) {
            $importer = new $class();
            return $importer;
        } else {
            throw new Exception('Class ' . $class . ' not found.');
        }
    }
}
