<?php

class CF_Search
{
    public $username;
    public $reportType;
    public $url;
    public $label;
    public $reportCategory;
    public $date;
    public $id;
    public $params;
    public $AdvancedReportsData;
    public $schedules;
    public $type;
    public $promise_filter;
    public $details;

    public $is_own;
    public $can_edit;
    public $can_delete;
    public $can_subscribe;
    public $is_subscribed;

    public $hasSchedules;
    public $totalSchedules;
    public $ownSchedules;
    public $showScheduleStatistic;

    public $readonly;
    public $is_public;

    public $sharedPermission;
    public $sharedBy;

    //used in schedule to provide correct link to the MP insance
    public $site_url;

    public function __construct($params = [])
    {
        $this->id = isset($params['id']) ? $params['id'] : null;
        $this->username = isset($params['username']) ? $params['username'] : null;
        $this->url = isset($params['url']) ? $params['url'] : null;
        $this->reportType = isset($params['reporttype']) ? $params['reporttype'] : null;
        $this->label = isset($params['label']) ? $params['label'] : null;
        $this->reportCategory = isset($params['reportcategory']) ? $params['reportcategory'] : null;
        $this->date = isset($params['date']) ? $params['date'] : null;
        $this->params = isset($params['params']) ? $params['params'] : null;
        $this->AdvancedReportsData = isset($params['advancedreportsdata'])
            ? json_decode($params['advancedreportsdata'], true)
            : null;
        $this->SQLString = isset($params['advancedreportsdata']['SQL']) ? $params['advancedreportsdata']['SQL'] : null;

        $this->schedules = isset($params['schedules']) ? $params['schedules'] : null;

        $this->type = isset($params['type']) ? $params['type'] : null;

        $this->readonly = isset($params['readonly']) ? $params['readonly'] : null;
        $this->is_public = isset($params['is_public']) ? $params['is_public'] : null;

        $this->params = isset($params['params']) ? $params['params'] : null;
        $this->promise_filter = isset($params['promise_filter']) ? $params['promise_filter'] : null;

        $this->details = isset($params['details']) ? $params['details'] : null;

        $this->site_url = isset($params['site_url']) ? $params['site_url'] : null;

        $this->sharedPermission = isset($params['sharedpermission'])
            ? PgsqlArrayToPhpArray($params['sharedpermission'])
            : [];
        $this->sharedBy = isset($params['sharedby']) ? PgsqlArrayToPhpArray($params['sharedby']) : [];

        $this->is_own = isset($params['is_own']) ? $params['is_own'] : null;
        $this->can_edit = isset($params['can_edit']) ? $params['can_edit'] : null;
        $this->can_delete = isset($params['can_delete']) ? $params['can_delete'] : null;
        $this->can_subscribe = isset($params['can_subscribe']) ? $params['can_subscribe'] : null;
        $this->is_subscribed = isset($params['is_subscribed']) ? $params['is_subscribed'] : null;

        $this->hasSchedules = isset($params['hasSchedules']) ? $params['hasSchedules'] : null;
        $this->totalSchedules = isset($params['totalSchedules']) ? $params['totalSchedules'] : null;
        $this->ownSchedules = isset($params['ownSchedules']) ? $params['ownSchedules'] : null;

        $this->showScheduleStatistic = isset($params['showScheduleStatistic'])
            ? $params['showScheduleStatistic']
            : null;
        $this->export_id = $params['export_id'] ?? null;
        $this->meta_data = isset($params['meta_data']) ? json_decode($params['meta_data'], true) : null;
    }

    public function getUsername()
    {
        return $this->username;
    }

    public function getUrl()
    {
        return $this->url;
    }

    public function getDate()
    {
        return getDateStatus($this->date, true, true);
    }

    public function getReportType()
    {
        return $this->reportType;
    }

    public function getLabel()
    {
        return $this->label;
    }

    public function getReportCategory()
    {
        return $this->reportCategory;
    }

    public function getReadonly()
    {
        return $this->readonly;
    }

    public function getIsPublic()
    {
        return $this->is_public;
    }

    public function getId()
    {
        return (int) $this->id;
    }
    /**
     * Returns the parameter form the url that is constructed
     * return @array with key as parameter and value as the searched value, if nothing returns empty array
     */
    public function getParameters()
    {
        $params = $this->params;
        return $params;
    }

    public function getAdvancedReportsData()
    {
        $AdvancedReportsData = $this->AdvancedReportsData;
        return $AdvancedReportsData;
    }

    public function getSQLString()
    {
        $SQLString = $this->params;
        return $SQLString;
    }

    public function getSchedules()
    {
        return $this->schedules;
    }

    public function getType()
    {
        return $this->type;
    }

    public function getDetails()
    {
        $details = $this->details;
        if ($details == null) {
            return [];
        } else {
            return json_decode($details);
        }
    }

    public function getPromiseFilter()
    {
        return $this->promise_filter;
    }

    /*
     * Used in scheduled report - provide correct link to the MP
     */
    public function getSiteUrl()
    {
        return $this->site_url;
    }

    public function getSharedPermission()
    {
        return $this->sharedPermission;
    }

    public function getSharedBy()
    {
        return $this->sharedBy;
    }
}
