<?php
/*
  Shows list of available alerts with stat information
  Shows list of available rules
 */
?>
<div class="contentWrapper">

    <div class="pageTitle singleTabs">
        <h1 class="inline-block">
            <span>Alerts overview</span>
            <div class="search-in-tab-view">
                <input type="text" placeholder="{{searchPlaceholder}}" ng-change="searchWidgets(searchTerm)" ng-model="searchTerm">
                <a class="clear-search" ng-class="{'no-width':!searchTerm}" ng-click="searchTerm='';searchWidgets()"></a>
            </div>

            <div class="btn-group no-btn pull-right">
                <a data-toggle="dropdown" class="btn no-btn dropdown-toggle option-menu right">
                 </a>
                <ul class="dropdown-menu pull-right">
                    <li ng-show="userEditable"><a ng-click="widgetData = {};modalWindow.open('addWidget', this)">Add new widget</a></li>
                    <li><a ng-href="/dashboard/conditions/add">Add new condition</a></li>
                    <li ng-show="userEditable" class="dropdown-submenu pull-left">
                        <a ng-click="">Pause all alerts</a>
                        <ul class="dropdown-menu">
                             <li ng-repeat="(itemId, item) in DCA.Pause_dropDown">
                                 <a ng-click="pauseAlert(null,item.value); $event.stopPropagation();">{{item.label}}</a>
                             </li>
                        </ul>
                    </li>
                    <li ng-show="userEditable">
                         <a ng-click="resumeAlert(); $event.stopPropagation();" href="javascript:void(0)">Resume all alerts</a>
                    </li>
                    <li><a ng-href="/dashboard/alerts/listAll" ng-click="searchTerm='';saveWidgetTmp();searchWidgets(searchTerm)">View all alerts</a></li>
                    <li><a ng-href="/dashboard/eventlog">View event log</a></li>
                </ul>
            </div>
        </h1>
    </div>

    <tabset class="tab-view">
        <tab heading="Alerts" select="tabSelected('alerts')">
            <div class="row-fluid float-left margin-bottom">
                <div>
                    <label class="margin-top">Filter by widget:</label>
                    <div class="btn-group">
                        <a data-toggle="dropdown" class="btn dropdown-toggle">
                            <span ng-show="widgetData.id">{{widgetData.name}}</span>
                            <span ng-show="!widgetData.id">All</span>
                            <span class="caret"></span>
                        </a>
                        <ul class="dropdown-menu dropup">
                        <li><a ng-click="saveWidgetTmp();searchWidgets(searchTerm)">All</a></li>
                        <li class="divider"></li>
                            <li ng-repeat="widget in widgets | FilterByObject:{type:'alerts'}">
                                <a ng-click="saveWidgetTmp(widget);searchWidgets(searchTerm)" href="javascript:void(0)">{{widget.name}}</a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="row-fluid float-left" ng-show="modalOpen.status!==true"><?php $this->load->view('/partials/_notification'); ?></div>
            <div class="row-fluid float-left" ng-show="!filteredWidgets.length || !filteredLength.length || !alerts.length ">
                <div class="alert alert-warning">There are no alerts to show</div>
            </div>
            <div ng-show="widgets.length" class="row-fluid float-left">

                <div class="margin-bottom-large alerts-container"
                    ng-repeat="widget in filteredWidgets = (widgets | FilterByObject:{id:widgetData.id}:true)"
                    ng-show="filteredAlerts.length"
                    ng-click="saveWidgetTmp(widget); searchWidgets(searchTerm); $event.stopPropagation();"
                >
                    <a id="{{widget.id}}" class="anchor"></a>
                    Widget: <b>{{widget.name}}</b>
                    <div ng-show="currentUser===widget.username" class="btn-group no-btn pull-right">
                        <a data-toggle="dropdown" class="btn no-btn dropdown-toggle option-dropdown">
                        </a>
                        <ul class="dropdown-menu pull-right">
                            <li ng-hide="widget.payload.hasOwnProperty('singleAlert') && widget.payload.singleAlert">
                                <a ng-click="saveWidgetTmp(widget);" ng-href="/dashboard/alerts/add?widgetId={{widget.id}}&dashboard={{ currentDashboard }}">Add alert</a>
                            </li>
                            <li><a ng-click="deleteWidget(widget.id); $event.stopPropagation();">Remove widget</a></li>
                        </ul>
                    </div>
                    <table class="table fixed margin-top table-horizontal">
                        <thead>
                        <th class="sort-head">
                            <a ng-click="orderByField='name'; reverseSort = !reverseSort; $event.stopPropagation();" href="javascript:void(0)">
                                Alert name
                                <span ng-show="orderByField=='name'">
                                    <i ng-show="!reverseSort" class="icon-chevron-down"></i>
                                    <i ng-show="reverseSort" class="icon-chevron-up"></i>
                                </span>
                            </a>
                        </th>
                        <th class="sort-head">
                             <a ng-click="orderByField='rule.name'; reverseSort = !reverseSort; $event.stopPropagation();" href="javascript:void(0)">
                                Condition
                                <span ng-show="orderByField=='rule.name'">
                                    <i ng-show="!reverseSort" class="icon-chevron-down"></i>
                                    <i ng-show="reverseSort" class="icon-chevron-up"></i>
                                </span>
                            </a>
                        </th>
                        <th class="sort-head">
                            <a ng-click="orderByField='rule.type'; reverseSort = !reverseSort; $event.stopPropagation();" href="javascript:void(0)">
                                Type
                                <span ng-show="orderByField=='rule.type'">
                                    <i ng-show="!reverseSort" class="icon-chevron-down"></i>
                                    <i ng-show="reverseSort" class="icon-chevron-up"></i>
                                </span>
                            </a>
                        </th>
                        <th class="sort-head">
                            <a ng-click="orderByField='sev'; reverseSort = !reverseSort; $event.stopPropagation();" href="javascript:void(0)">
                                Triggered
                                <span ng-show="orderByField=='sev'">
                                    <i ng-show="!reverseSort" class="icon-chevron-down"></i>
                                    <i ng-show="reverseSort" class="icon-chevron-up"></i>
                                </span>
                            </a>
                        </th>
                        <th ng-show="currentUser===widget.username" class="right actions pause">Actions</th>
                        </thead>
                        <tbody>
                             <tr ng-repeat="alert in filteredAlerts = (alerts | FilterByObject:{widgetid: widget.id}:true | alertSearchFilter:searchTerm) | arrayOrderBy:severitySortFunction:reverseSort | orderBy:orderByField:reverseSort ">
                                <td>
                                    <a ng-click="saveWidgetTmp(widget.id);$event.stopPropagation();" ng-href="/dashboard/alerts/result/{{alert.id}}">{{alert.name}}</a>
                                </td>
                                <td>
                                    {{alert.rule.name}}
                                </td>
                                <td>
                                    <span class="upper-first">{{alert.rule.type}}</span>
                                </td>
                                <td data-toggle="tooltip" title="Severity: {{alert.severity}}" >
                                    <i class="icon-circle severity" ng-class="alert.severity"></i>
                                    <span>{{alert.failHosts}} / {{alert.totalHosts}}</span>
                                </td>
                                <td ng-show="currentUser===widget.username" class="right">
                                    <div class="inline" ng-show="!alert.paused" style="margin-right:5px;">
                                        <div class="btn-group no-btn">
                                             <a data-toggle="dropdown" class="btn no-btn dropdown-toggle">
                                                 <span ng-hide="">pause</span>
                                                 <i class="icon-caret-down"></i>
                                             </a>
                                             <ul class="dropdown-menu pull-right">
                                                 <li ng-repeat="(itemId, item) in DCA.Pause_dropDown">
                                                     <a ng-click="pauseAlert(alert,item.value); $event.stopPropagation();">{{item.label}}</a>
                                                 </li>
                                             </ul>
                                         </div>
                                    </div>
                                    <div class="inline" ng-show="alert.paused" style="margin-right:5px;">
                                        <div class="btn-group no-btn">
                                             <a data-toggle="dropdown" class="btn no-btn dropdown-toggle">
                                                <span ng-show="isAlertAlive(alert.pause)">{{alert.pause | convertTime}}</span>
                                                <span ng-show="!isAlertAlive(alert.pause)">paused</span>
                                                <i class="icon-caret-down"></i>
                                             </a>
                                             <ul class="dropdown-menu pull-right">
                                                 <li>
                                                     <a ng-click="resumeAlert(alert); $event.stopPropagation();" href="javascript:void(0)">Resume</a>
                                                 </li>
                                             </ul>
                                         </div>
                                    </div>

                                    <a ng-click="$event.stopPropagation();" ng-href="/dashboard/alerts/edit/{{alert.id}}" class="edit"></a>
                                    <a ng-click="removeAlertFromWidget(alert.widgetid, alert.id, alert.name); $event.stopPropagation();" href="javascript:void(0)" class="remove"></a>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </tab>
        <tab heading="Conditions" select="tabSelected('conditions')" active="conditionsActive">
            <div ng-show="modalOpen.status!==true"><?php $this->load->view('/partials/_notification'); ?></div>
            <div class="alert alert-warning" ng-show="filteredRules.length == 0">No conditions found</div>

            <div ng-show="filteredRules.length" class="row-fluid">
                <table class="table margin-top table-horizontal" ng-show="rulesList.length >0">
                    <thead>
                    <th class="sort-head">
                       <a ng-click="orderByField='name'; reverseSort = !reverseSort">
                            Name
                            <span ng-show="orderByField=='name'">
                                <i ng-show="!reverseSort" class="icon-chevron-down"></i>
                                <i ng-show="reverseSort" class="icon-chevron-up"></i>
                            </span>
                        </a>
                    </th>
                    <th class="sort-head">
                       <a ng-click="orderByField='type'; reverseSort = !reverseSort">
                            Type
                            <span ng-show="orderByField=='type'">
                                <i ng-show="!reverseSort" class="icon-chevron-down"></i>
                                <i ng-show="reverseSort" class="icon-chevron-up"></i>
                            </span>
                        </a>
                    </th>
                    <th>
                        Description
                    </th>
                    <th>
                        Details
                    </th>
                    <th>
                        Author
                    </th>
                    <th class="right actions">
                        Actions
                    </th>
                    </thead>
                    <tbody>
                        <tr ng-repeat="rule in filteredRules = (rulesList | ruleSearchFilter:searchTerm) |  arrayOrderBy:orderByField:reverseSort">
                            <td class="no-wrap">{{rule.name}}</td>
                            <td>{{rule.type | DCA_ValueToString:'RuleTypes_dropDown' }}</td>
                            <td>{{rule.description}}</td>
                            <td>
                                <div class="muted" ng-switch on="rule.type">
                                    <div ng-switch-when="policy">
                                        <ul class="unstyled break-all">
                                            <li ng-show="rule.policyConditions.filterBy && rule.filterItemName">
                                                <span class="upper-first"><h5 class="inline">{{rule.policyConditions.filterBy}}:</h5></span> {{rule.policyConditions.filterItemName}}
                                            </li>
                                            <li ng-show="rule.policyConditions.promisehandle">
                                                <h5 class="inline">Promise handle:</h5> {{rule.policyConditions.promisehandle}}
                                            </li>
                                            <li>
                                                <h5 class="inline">Status:</h5> <span class="upper-first">{{convertStatus(rule.policyConditions.promiseoutcome)}}</span>
                                            </li>
                                        </ul>
                                    </div>

                                    <div ng-switch-when="inventory">
                                         <ul class="unstyled break-all">
                                            <li ng-repeat="filter in rule.inventoryConditions.filters">
                                                <h5 class="inline">{{filter.label}}:</h5> {{filter.condition | FilterConditionLabel:filter}} <span ng-show="filter.type==='string'">'{{filter.value}}'</span><span ng-show="filter.type!=='string'">{{filter.value}}</span>
                                            </li>
                                        </ul>
                                    </div>

                                   <div ng-switch-when="softwareupdate">
                                       <ul class="unstyled break-all">
                                           <li>
                                               <b>Package name:</b> <span ng-if="rule.softwareUpdateConditions.patchname!=''">{{rule.softwareUpdateConditions.patchname}}</span><span ng-if="!rule.softwareUpdateConditions.patchname">All</span>
                                           </li>
                                           <li>
                                               <b>Architecture:</b> <span ng-if="rule.softwareUpdateConditions.patcharchitecture!=''">{{rule.softwareUpdateConditions.patcharchitecture}}</span><span ng-if="!rule.softwareUpdateConditions.patcharchitecture">All</span>
                                           </li>
                                       </ul>
                                    </div>
                                </div>
                            </td>
                            <td class="muted">{{rule.username}}</td>
                            <td class="right"><a ng-show="rule.username===currentUser" class="remove" ng-click="deleteRule(rule.id,$index)" href="javascript:void(0)"></a></td>
                        </tr>
                    </tbody>
                </table>
            </div>

        </tab>
    </tabset>
</div>
<script>
    processPageBeforeLeave();
</script>


<?php
    $this->load->view('/partials/_addWidgetModal');
?>
