<form class="addNodeDialog addTreeDialog form-horizontal confirm-before-leave">

    <fieldset>

        <div class="control-group">
            <label for="astrolabe-add-node-label" class="control-label">Title</label>
            <div class="controls">
                <input type="text" id="astrolabe-add-tree-label" name="treeLabel" class="required" minlength="1" value="<?= !empty($treename) ? htmlspecialchars($treename) : '' ?>"/>
                <p id="astrolabe-add-tree-label-error" class="astrolabeAddNodeDialogError"></p>
            </div>
        </div>

        <div class="control-group">
            <label for="" class="control-label">Share categorization with these user roles</label>
            <div class="controls">
                <select name="treeRoles" id="astrolabe-add-tree-roles-multiselect" multiple="multiple">
                    <?php foreach ((array) $roles as $role) { ?>
                    <option value="<?= htmlspecialchars($role) ?>" <?php echo !empty($selectedRoles) && in_array($role, $selectedRoles) ? ' selected="selected"':''; ?>><?= htmlspecialchars($role) ?></option>
                    <?php } ?>
                </select>
            </div>
        </div>
        <?php if ($isAdmin) { ?>
        <div class="control-group">
            <div class="controls">
                <div class="checkbox">
                     <label>
                        <input name="makeGlobal" type="checkbox" id="astrolabe-add-tree-make-global" <?php echo !empty($globalTree) ? 'checked': '' ?>> Add this categorization to all users' accounts
                    </label>
                </div>
            </div>
        </div>
        <?php } ?>
    </fieldset>
    <?php if (empty($editMode)) { ?>
    <fieldset>
        <legend>Add subcategories</legend>

        <?php if (empty($editMode)) { ?>
            <label for="astrolabe-add-node-label" class="control-label hide addedNodesLabel">Added Nodes</label>
            <div class="controls">
                <div class="addedTreeNodes" style="max-width:300px;margin:5px;">
                </div>
            </div>
        <?php } ?>

        <div class="astrolabe addNodeDialog">
            <div class="control-group">
                <label for="astrolabe-add-node-label" class="control-label">Title</label>
                <div class="controls">
                    <input name="nodeLabel" type="text" id="astrolabe-add-node-label" class="required" minlength="1"/>
                    <p id="astrolabe-add-node-label-error" class="astrolabeAddNodeDialogError"></p>
                </div>
            </div>

            <div class="control-group">
                <label for="astrolabe-add-node-class"  class="control-label">CFEngine class expression (.*+[])</label>

                <div class="controls">
                    <div class="">
                        <input name="nodeClass" type="text" id="astrolabe-add-node-class" minlength="1" />
                        <div class="classFinderIcon"><a href="#">show all classes</a></div>
                    </div>

                    <p id="astrolabe-add-node-class-error" style="clear: both;" class="astrolabeAddNodeDialogError"></p>
                </div>
            </div>
            <div>
                <div class="control-group">
                    <label for="astrolabe-add-node-class"  class="control-label"></label>
                    <div class="controls">
                        <span class="addNodeForTree nav pills token token-cyan">  <i class="icon-plus"></i> Add another subcategory</span>
                    </div>

                </div>
            </div>
        </div>
    </fieldset>
    <?php } ?>
</form>

<script type="text/javascript">
    $(document).ready(function() {
        $('.addTreeDialog .classFinderIcon').classfinder({
            defaultbehaviour: false,
            baseUrl: '<?php echo site_url() ?>',

            complete: function(event,data)
            {
                var $classInput = $('#astrolabe-add-node-class');
                var value = $.trim($classInput.val());
                if (value) {
                    value = value + '|';
                }
                $classInput.val(value + data.selectedclass);
                $('.ui-tooltip').remove();
            }
        });

        $('#astrolabe-add-tree-roles-multiselect').multiselect({
            buttonClass: 'btn',
            buttonWidth: 'auto',
            buttonTitle: function() {},
            buttonText: function(options) {
                if (options.length == 0) {
                    return 'None selected';
                }
                else if (options.length > 3) {
                    return options.length + ' selected';
                }
                else {
                    var selected = '';
                    options.each(function() {
                        selected += $(this).text() + ', ';
                    });
                    return selected.substr(0, selected.length -2);
                }
            }
        }).hide();
    });
</script>
