<?php
class Dashboard extends Cf_Controller
{
    public function __construct()
    {
        parent::__construct();
        setCurrentApplication('dashboard');
    }

    public function index()
    {
        $requiredjs = [
            ['dist/angular-base.bundle.js'],

            ['dashboard/dca.js'],

            ['dashboard/app.js'],

            ['dashboard/controllers/dashboardController.js'],
            ['dashboard/controllers/alertsController.js'],
            ['dashboard/controllers/eventsController.js'],

            ['dashboard/directives/directives.js'],
            ['dashboard/directives/widgets.js'],
            ['dashboard/directives/hostCountWidget.js'],
            ['dashboard/directives/decommissionedHostsWidget.js'],
            ['dashboard/directives/fileChangesWidget.js'],
            ['dashboard/directives/notKeptWidget.js'],
            ['dashboard/directives/inventoryWidget.js'],
            ['dashboard/directives/complianceWidget.js'],
            ['advancedreports/helpers/complianceHelpers.js'],
            ['common_directives/high-chart.js'],
            ['common_directives/health-issue.js'],
            ['common_directives/editableField.js'],

            ['dashboard/services/autocompleteService.js'],
            ['dashboard/services/alertsService.js'],
            ['dashboard/services/rulesService.js'],
            ['dashboard/services/widgetwizardService.js'],
            ['dashboard/services/dashboardService.js'],
            ['dashboard/services/changesService.js'],
            ['dashboard/services/hostCountService.js'],
            ['dashboard/services/decommissionedHostsService.js'],
            ['dashboard/services/fileChangesService.js'],
            ['dashboard/services/notKeptWidgetService.js'],
            ['dashboard/services/notificationService.js'],
            ['dashboard/services/eventsLogService.js'],
            ['dashboard/services/modalWindowService.js'],
            ['dashboard/services/widgetService.js'],
            ['dashboard/services/welcomeWizardService.js'],
            ['dashboard/services/userService.js'],
            ['advancedreports/services/reportService.js'],

            // inventory widgets
            ['dashboard/helpers/inventory/BaseInventoryWidgetClass.js'],
            ['dashboard/helpers/inventory/BarInventoryWidgetClass.js'],
            ['dashboard/helpers/inventory/PieInventoryWidgetClass.js'],
            ['dashboard/helpers/inventory/GaugeInventoryWidgetClass.js'],
            ['dashboard/helpers/inventory/TableInventoryWidgetClass.js'],

            ['dashboard/helpers/widgetHelper.js'],
            ['dashboard/helpers/tourGuideHelper.js'],
            ['dashboard/helpers/changesWidgetHelper.js'],
            ['dashboard/helpers/hostCountWidgetHelper.js'],
            ['dashboard/helpers/decommissionedHostsWidgetHelper.js'],
            ['dashboard/helpers/notKeptWidgetHelper.js'],
            ['dashboard/helpers/inventoryWidgetHelper.js'],
            ['dashboard/helpers/dashboardHelper.js'],
            ['dashboard/helpers/commonHelper.js'],
            ['dashboard/helpers/fileChangesWidgetHelper.js'],
            ['dashboard/helpers/complianceWidgetHelper.js'],

            ['dashboard/filters/dashFilters.js'],

            // environment selector
            ['common_directives/environment/services/environmentService.js'],
            ['common_directives/environment/services/naviTreeService.js'],
            ['common_directives/environment/directives/environment_directive.js'],
            ['common_directives/environment/directives/environmentSelectionDirective.js'],

            // environment selector
            ['common_directives/environment/services/environmentService.js'],
            ['common_directives/environment/services/naviTreeService.js'],
            ['common_directives/environment/directives/environment_directive.js'],
            ['common_directives/environment/directives/environmentSelectionDirective.js'],

            // hosts include exclude selector
            ['common_directives/hostsInclude/services/paginationService.js'],
            ['common_directives/hostsInclude/services/includeExcludeService.js'],
            ['common_directives/hostsInclude/services/autocompleteService.js'],
            ['common_directives/hostsInclude/services/naviTreeService.js'],
            ['common_directives/hostsInclude/directives/include_exclude_directive.js'],
            ['common_directives/hostsInclude/directives/includeExcludeSelectionDirective.js'],

            // additional fields for inventory. Application specific!
            ['dashboard/invenory_data_addons.js'],

            // inventory filter for inventory alerts
            ['common_directives/inventory/inventory_dca.js'],
            ['common_directives/inventory/services/inventoryService.js'],
            ['common_directives/inventory/services/inventoryDataService.js'],
            ['common_directives/inventory/services/inventoryFilterService.js'],
            ['common_directives/inventory/helpers/inventoryHelper.js'],
            ['common_directives/inventory/directives/inventoryFilterDirectiveCtrl.js'],
            ['common_directives/inventory/directives/inventoryFilter_directive.js'],
            ['common_directives/objectsFilter.js'],

            ['groups/services/personalGroupsService.js'],
            ['groups/services/sharedGroupsService.js'],
            ['advancedreports/dca.js'],
        ];

        $highchartsjs = [['dist/highcharts.bundle.js']];

        $this->carabiner->js($requiredjs, $requiredjs, true, false, 'footer');
        $this->carabiner->js($highchartsjs, $highchartsjs, true, false, 'footer');

        $data = [
            'title' => $this->lang->line('mission_portal_title') . ' - ' . 'Dashboard',
        ];

        $data['isAdmin'] = false;

        $user_role = $this->session->userdata('roles');
        if (empty($user_role)) {
            $user_role = [];
        }
        if (in_array('admin', $user_role) === true) {
            $data['isAdmin'] = true;
        }

        $this->template->load('template', 'dashboard/index', $data);
    }

    /**
     * Load partials
     *
     * @param type $partial - name of the view
     */
    public function partials($partial)
    {
        $view = 'partials/' . $partial . '.php';
        $this->load->view($view);
    }
}
