var naviTreeService = Class.extend({
    LOAD_NAVITREE_PROFILE_URL: MP_SITE_URL + '/astrolabe/profile/',
    SEARCH_HOSTS_URL: MP_SITE_URL + '/host/searchHost?query=',
    SEARCH_HOSTS_BY_INVENTORY_URL: MP_SITE_URL + '/host/searchHostsByInventory?query=',
    GET_HOSTS_BY_INVENTORY_FILTER_URL: MP_SITE_URL + '/host/hostsByInventoryFilter',

    LOAD_NAVITREE_ASTRO_HOSTS:        MP_SITE_URL + '/astrolabe/host/',

    /**
     * @return Service handler
     */
    getTreeProfiles: function() {
        return this.$http.get(this.LOAD_NAVITREE_PROFILE_URL, {
            cache: false
        });
    },
    getTreeNodes: function(tree) {
        var url = this.LOAD_NAVITREE_PROFILE_URL + encodeURIComponent(tree.id) + '/' + tree.shared + '/' + tree.sharedFrom;
        return this.$http.get(url, {
            cache: false
        });

    },

    searchHosts: function(query, limit = 7, offset = 0, withMeta = false) {
        var url = this.SEARCH_HOSTS_URL + encodeURIComponent(query) + `&limit=${limit}&offset=${offset}&withMeta=${withMeta ? 'true' : 'false'}`;
        return this.$http.get(url, {
            cache: false
        });

    },
    searchHostsByInventory: function(query, limit = 7, offset = 0, queryIsIpMask = false) {
        var url = this.SEARCH_HOSTS_BY_INVENTORY_URL + encodeURIComponent(query) + `&limit=${limit}&offset=${offset}&ip_mask=${queryIsIpMask}`;
        return this.$http.get(url, {
            cache: false
        });

    },

    getHostsByInventory: function(filter, limit = -1, offset = 0) {
        return this.$http({
            url: this.GET_HOSTS_BY_INVENTORY_FILTER_URL,
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
            },
            data: $.param({filter}),
            transformRequest: angular.identity
        });

    },
    getNodeHosts: function (includesArray, count, page) {
        let url = this.LOAD_NAVITREE_ASTRO_HOSTS;

        return this.$http({
            url: url,
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
            },
            data: $.param({'page': page, 'count': count, 'includes': includesArray}),
            transformRequest: angular.identity
        });

    }
});



(function() {

    var naviTreeServiceProvider = Class.extend({
        instance: new naviTreeService(),
        $get: ['$http', function($http) {
            this.instance.$http = $http;
            return this.instance;
        }]
    });

    angular.module('inclExcl.naviTreeService', [])
        .provider('IENaviTreeService', naviTreeServiceProvider);
}());