<?php

$secretsIniPath = realpath(BASEPATH . '../../secrets.ini');
if (!file_exists($secretsIniPath)) {
    // ldap tests case
    $secretsIniPath = SECRETS_INI_PATH;
}
file_exists($secretsIniPath) || die('Wrong secrets.ini path');
$secrets = parse_ini_file($secretsIniPath);

return [
    'settings' => [
        'displayErrorDetails' => false, // set to false in production
        'addContentLengthHeader' => false, // Allow the web server to send the content-length header

        // Monolog settings
        'logger' => [
            'name' => 'app',
            'path' => BASEPATH . '../../logs/application/ldap.log',
            'level' => \Monolog\Logger::ERROR,
        ],
    ],

    // LDAP Configuration Options
    'accessToken' => $secrets['ldap_api_secret'],

    'ldap' => require_once CONFIG_PATH . '/settings.ldap.php',
];
