policyAnalyzerApp.directive('policySummary', function () {
    return {
        templateUrl: MP_SITE_URL + '/policy/analyzer/partials/policySummary',
        restrict: 'A',
        scope: {
            onLineSelected: '&?',
            onFileSelected: '&?',
            tableData: '=?',
            view: '=',
            sortReorder: '&?',
            paginator: '=',
        },

        link: function ($scope, element, attr) {
            $scope.rowSelected = function (line) {
                $scope.onLineSelected({line: line});
            };
            $scope.getIndexByColumnName = function (name) {
                let columnIndex = false;
                if ($scope.view.tablehead != undefined && $scope.view.tablehead.length > 0) {
                    $scope.view.tablehead.forEach(function (value, index) {
                        if (value.name == name) {
                            columnIndex = index;
                        }
                    })
                }
                return columnIndex;
            }

            $scope.$watchCollection('view', function (value) {
                let lineColumnIndex = $scope.getIndexByColumnName('Line');
                let filePathIndex = $scope.getIndexByColumnName('Policy file');

                if ($scope.view.rows != undefined && $scope.view.rows.length > 0) {
                    $scope.view.rows.forEach(function (data, key) {
                        $scope.view.rows[key][lineColumnIndex] = '<a class="line-number" ng-click="onLineSelected({line: ' + $scope.view.rows[key][lineColumnIndex] + '})">' + $scope.view.rows[key][lineColumnIndex] + '</a>';
                        $scope.view.rows[key][filePathIndex] = '<a class="file-path" ng-click="onFileSelected({file: {path : {absolute: \'' + $scope.view.rows[key][filePathIndex] + '\'}}});">' + $scope.view.rows[key][filePathIndex] + '</a>';
                    })
                }
            })

        }
    };

});

policyAnalyzerApp.directive('compile', ['$compile', function ($compile) {
    return function (scope, element, attrs) {
        scope.$watch(
            function (scope) {
                return scope.$eval(attrs.compile);
            },
            function (value) {
                element.html(value);
                $compile(element.contents())(scope);
            }
        );
    };
}]);
