<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 *
 */

/**
 * Code returned as http status codes
 */
class promise_model extends Cf_Model
{
    private $promisesfilter_mode = '';
    private $defaultPromisesfilterMode = '';

    public function __construct()
    {
        parent::__construct();
        $this->defaultPromisesfilterMode = $this->config->item('default_promisesfilter_mode');
        $this->setPromisesFiltermode($this->defaultPromisesfilterMode);
    }

    public function setPromisesfilterMode($mode)
    {
        $this->promisesfilter_mode = $mode;
    }

    /**
     *
     * @param type $username
     * @param type $handle
     * @return type string
     */
    public function getBundleByPromiseHandle($username, $handle)
    {
        try {
            $rawdata = cfpr_bundle_by_promise_handle($username, $handle);
            //$data = $this->checkData($rawdata);
            if (is_string($rawdata) && $rawdata != '') {
                return $rawdata;
            } else {
                throw new Exception($this->lang->line('promise_body_null'), 204);
            }
        } catch (Exception $e) {
            log_message(log_level_for_exception($e), $e->getMessage() . ' ' . $e->getFile() . ' line:' . $e->getLine());
            throw $e;
        }
    }

    /**
     *
     * @param type $username
     * @param type $handle
     * @return type array
     */
    public function getPromiseDetails($username, $handle)
    {
        try {
            $rawdata = cfpr_promise_details($username, $handle);
            $data = $this->checkData($rawdata);
            if (is_array($data) && $this->hasErrors() == 0) {
                return $data;
            } else {
                throw new Exception($this->getErrorsString());
            }
        } catch (Exception $e) {
            log_message(log_level_for_exception($e), $e->getMessage() . ' ' . $e->getFile() . ' line:' . $e->getLine());
            throw $e;
        }
    }

    /**
     *
     * @param type $username
     * @param type $bundle
     * @return type array
     */
    public function getPromiseListByBundle($username, $bundle, $resultPerPage = 0, $page = 0)
    {
        if ($bundle == '') {
            return [];
        }

        try {
            $bundle_type = $this->getBundleType($bundle);
            $rawdata = cfpr_promise_list_by_bundle($username, $bundle_type, $bundle, $resultPerPage, $page);
            $data = $this->checkData($rawdata);
            if (is_array($data) && $this->hasErrors() == 0) {
                return $data;
            } else {
                throw new Exception($this->getErrorsString());
            }
        } catch (Exception $e) {
            log_message(log_level_for_exception($e), $e->getMessage() . ' ' . $e->getFile() . ' line:' . $e->getLine());
            throw $e;
        }
    }

    /**
     * List of promise searching by bundle
     * @param string $username
     * @param string $bundle
     * @return array
     */
    public function getPromiseListByBundleRx($username, $bundleType, $bundle, $resultPerPage = 0, $page = 0)
    {
        try {
            $query = 'SELECT DISTINCT
                      PromiseDefinitions.PromiseHandle,
                      PromiseDefinitions.NameSpace,
                      PromiseDefinitions.Bundle,
                      PromiseDefinitions.Promisee,
                      PromiseDefinitions.Promiser
                     FROM PromiseDefinitions';
            if (!empty($bundle)) {
                $escapedBundle = $this->db->escape_str($bundle);
                $query = $query . sprintf(' WHERE PromiseDefinitions.Bundle REGEXP ("%s")', $escapedBundle);
            }
            $skip = (int) ($page - 1) * $resultPerPage;
            $inclist = [];
            $exlist = [];

            $data = $this->advancedreports_model->runQuery(
                $username,
                $query,
                'PromiseHandle',
                false,
                $skip,
                $resultPerPage,
                $this->promisesfilter_mode,
                $inclist,
                $exlist,
            );

            if (is_array($data)) {
                return $data['rows'];
            } else {
                throw new Exception($this->getErrorsString());
            }
        } catch (Exception $e) {
            log_message(log_level_for_exception($e), $e->getMessage() . ' ' . $e->getFile() . ' line:' . $e->getLine());
            throw $e;
        }
    }

    /**
     * List of promise by handle
     * @param String $username
     * @param string $handle
     * @return array
     */
    public function getPromiseListByHandleRx($username, $handle = '.*', $resultPerPage = 0, $page = 0)
    {
        try {
            $query = 'SELECT DISTINCT
                      PromiseDefinitions.PromiseHandle,
                      PromiseDefinitions.NameSpace,
                      PromiseDefinitions.Bundle,
                      PromiseDefinitions.Promisee,
                      PromiseDefinitions.Promiser
                     FROM PromiseDefinitions';
            if (!empty($handle)) {
                $escapedHandle = $this->db->escape_str($handle);
                $query = $query . sprintf(' WHERE PromiseDefinitions.PromiseHandle REGEXP ("%s")', $escapedHandle);
            }

            $skip = (int) ($page - 1) * $resultPerPage;
            $inclist = [];
            $exlist = [];

            $data = $this->advancedreports_model->runQuery(
                $username,
                $query,
                'PromiseHandle',
                false,
                $skip,
                $resultPerPage,
                $this->promisesfilter_mode,
                $inclist,
                $exlist,
            );
            if (is_array($data)) {
                return $data['rows'];
            } else {
                throw new Exception($this->getErrorsString());
            }
        } catch (Exception $e) {
            log_message(log_level_for_exception($e), $e->getMessage() . ' ' . $e->getFile() . ' line:' . $e->getLine());
            throw $e;
        }
    }

    /**
     *
     * @param type $bundle
     * @return type string
     */
    public function getBundleType($bundle)
    {
        $bundle_type = cfpr_get_bundle_type($bundle);
        try {
            $rawdata = cfpr_get_bundle_type($bundle);
            if (is_string($rawdata) && $rawdata != '') {
                return $rawdata;
            } else {
                throw new Exception('Empty type returned for given bundle');
            }
        } catch (Exception $e) {
            log_message(log_level_for_exception($e), $e->getMessage() . ' ' . $e->getFile() . ' line:' . $e->getLine());
            throw $e;
        }
    }

    /**
     * List of promise by promiser
     * @param String $username
     * @param string $promiser
     * @return array
     */
    public function getPromiseListByPromiserRx($username, $promiser = null, $resultPerPage = 0, $page = 0)
    {
        try {
            $query = 'SELECT DISTINCT
                      PromiseDefinitions.PromiseHandle,
                      PromiseDefinitions.NameSpace,
                      PromiseDefinitions.Bundle,
                      PromiseDefinitions.Promisee,
                      PromiseDefinitions.Promiser
                     FROM PromiseDefinitions';
            if (!empty($promiser)) {
                $escapedPromiser = $this->db->escape_str($promiser);
                $query = $query . sprintf(' WHERE PromiseDefinitions.Promiser REGEXP ("%s")', $escapedPromiser);
            }

            $skip = (int) ($page - 1) * $resultPerPage;
            $inclist = [];
            $exlist = [];

            $data = $this->advancedreports_model->runQuery(
                $username,
                $query,
                'PromiseHandle',
                false,
                $skip,
                $resultPerPage,
                $this->promisesfilter_mode,
                $inclist,
                $exlist,
            );
            if (is_array($data)) {
                return $data['rows'];
            } else {
                throw new Exception($this->getErrorsString());
            }
        } catch (Exception $e) {
            log_message(log_level_for_exception($e), $e->getMessage() . ' ' . $e->getFile() . ' line:' . $e->getLine());
            throw $e;
        }
    }
}
