<?php
include_once FCPATH . 'application/libraries/Cf_tcpdf.php';

class Csv2Pdf extends cf_base_controller
{
    public $statusFile = '';
    public $abortFile = '';
    public static $statusBeforeHtmlWriting = '75.5';

    public function __construct()
    {
        parent::__construct();
        $this->load->model('report_model');
        $scriptTimeOut = !$this->config->item('pdf_generation_timeout')
            ? $this->config->item('pdf_generation_timeout')
            : 7200;
        set_time_limit($scriptTimeOut);
        // do not apply memory limit to the csv to pdf conversion
        ini_set('memory_limit', '-1');
    }

    public function convert(
        $csvFilePath = '',
        $reportID = '',
        $reportTitle,
        $reportDescription,
        $outputFileName = '',
        $outputFilePath = '',
    ) {
        // CodeIgniter "parse" shashes, so we ereceive invalid data sa parameters. to avoid that - we use SERVER array
        $csvFilePath = isset($_SERVER['argv'][3]) ? $_SERVER['argv'][3] : '';
        $reportID = isset($_SERVER['argv'][4]) ? $_SERVER['argv'][4] : '';
        $reportTitle = trim(isset($_SERVER['argv'][5]) ? base64_decode($_SERVER['argv'][5]) : '', "'");
        $reportDescription = trim(isset($_SERVER['argv'][6]) ? base64_decode($_SERVER['argv'][6]) : '', "'");
        $outputFileName = isset($_SERVER['argv'][7]) ? $_SERVER['argv'][7] : '';
        $outputFilePath = isset($_SERVER['argv'][8]) ? $_SERVER['argv'][8] : '';

        log_message(
            'info',
            "csv2pdf->convert(): Parameters: csvFilePath: $csvFilePath, reportID: $reportID, reportTitle: reportTitle, reportDescription: $reportDescription, outputFileName: $outputFileName, outputFilePath: $outputFilePath",
        );

        if ($outputFilePath == '') {
            $tmpDir = realpath(get_tmpdir());
        } else {
            $tmpDir = realpath($outputFilePath);
        }

        log_message('info', "csv2pdf->convert(): tmpDir: $tmpDir");

        if (empty($outputFileName)) {
            $pdfFileName = $tmpDir . DIRECTORY_SEPARATOR . basename($csvFilePath, '.csv') . '.pdf';
        } else {
            $pdfFileName = $tmpDir . DIRECTORY_SEPARATOR . $outputFileName . '.pdf';
        }

        log_message('info', "csv2pdf->convert(): pdfFileName: $pdfFileName");

        $this->statusFile = $pdfFileName . '.status';
        $this->abortFile = $tmpDir . DIRECTORY_SEPARATOR . basename($csvFilePath, '.csv') . '.abort';

        log_message('info', "csv2pdf->convert(): statusFile: $this->statusFile");
        log_message('info', "csv2pdf->convert(): abortFile:  $this->abortFile");

        file_put_contents($this->statusFile, 0);
        $numberOfLines = fileTotalLines($csvFilePath);

        log_message('info', "csv2pdf->convert(): numberOfLines: $numberOfLines");

        // read the file
        // line-by line
        // convert to pdf in the same directory
        $row = 1;

        $pdf = new Cf_tcpdf(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
        $pdf->SetPrintHeader(false);
        $pdf->AddPage();

        $col_len = [];

        try {
            $pdf->printHeader($reportTitle, $reportDescription);
        } catch (Exception $e) {
            throw $e;
            exit(1);
        }

        log_message('info', "csv2pdf->convert(): open csv file: $csvFilePath");

        if (($handle = @fopen($csvFilePath, 'r')) !== false) {
            $htmlTable = '<table cellpadding="5" border="1">';
            while (($data = fgetcsv($handle, 0, ',', '"', '"')) !== false) {
                // echo 'writing line:: ' . $row . ' out of total:: ' . $numberOfLines . PHP_EOL;
                $num = count($data);
                if ($row == 1) {
                    for ($i = 0; $i < $num; $i++) {
                        $col_len[$i] = 100 / $num;
                    }
                    $htmlTable .= '<tr>';
                    foreach ($data as $d) {
                        $htmlTable .= "<td><strong>{$d}</strong></td>";
                    }
                    $htmlTable .= '</tr>';
                    $row++;
                    continue;
                }
                $htmlTable .= '<tr>';
                foreach ($data as $d) {
                    $htmlTable .= "<td>{$d}</td>";
                }
                $htmlTable .= '</tr>';
                $row++;
                $this->_updateStatusFile($this->statusFile, $row, $numberOfLines);
            }
            $htmlTable .= '</table>';

            file_put_contents($this->statusFile, self::$statusBeforeHtmlWriting);
            $pdf->SetFontSize(9);
            $pdf->writeHTML($htmlTable, true, false, false, false, '');
            fclose($handle);
            $pdf->lastPage();
            $pdf->Output($pdfFileName, 'F');
            file_put_contents($this->statusFile, 100);
            chown($pdfFileName, $this->config->item('notification_script_user'));
            log_message('info', 'csv2pdf->convert(): finished');
        } else {
            // cannot find csv file to open
            file_put_contents($this->statusFile, -1);
            log_message('error', 'csv2pdf->convert(): cannot find csv file to open. Looking for: ' . $csvFilePath);
            exit(1);
        }
        $this->_cleanup();
    }

    /**
     * Clean up function to clean the files in the directory
     * Delete files older than 1 day (.csv,.pdf,.status)
     */
    public function _cleanup()
    {
        $path = get_tmpdir();
        $olderThan = 86400; // sec
        if ($handle = opendir($path)) {
            while (false !== ($file = readdir($handle))) {
                $filePath = $path . $file;
                if (time() - filectime($filePath) >= $olderThan) {
                    $path_parts = pathinfo($filePath);
                    if (in_array($path_parts['extension'], ['pdf', 'csv', 'status', 'pid', 'log'])) {
                        @unlink($filePath);
                    }
                }
            }
            closedir($handle);
        }
    }

    public function _updateStatusFile($statusFile, $row, $total)
    {
        // divide percentage by 1.5, because in case of big files status is not equal to percentage or processed csv rows
        // as writeHtml function will take more time than preparation of the actual HTML content
        $percent = floor(($row * 100) / $total / 1.5);
        if ($percent % 3 == 0 || $percent % 5 == 0) {
            $this->checkForTermination();
            file_put_contents($statusFile, $percent);
            log_message('info', "csv2pdf->_updateStatusFile(): $percent");
        }
    }

    /**
     * Looks for abort file and terminate if found
     */
    public function checkForTermination()
    {
        $abortFile = $this->abortFile;
        if (is_file($abortFile) === true) {
            // remove the files and exit the process
            file_put_contents($this->statusFile, -1);
            exit(1);
        }
    }
}
