import type { Options as OptionsOfCreateCache } from "@emotion/cache";
import type { NextComponentType } from "next";
/**
 * @see <https://docs.tss-react.dev/ssr/next>
 * This utility implements https://emotion.sh/docs/ssr#advanced-approach
 * */
export declare function createEmotionSsrAdvancedApproach(
/** This is the options passed to createCache() from 'import createCache from "@emotion/cache"' */
options: Omit<OptionsOfCreateCache, "insertionPoint"> & {
    prepend?: boolean;
}, 
/**
 * By default <CacheProvider /> from 'import { CacheProvider } from "@emotion/react"'
 *
 * NOTE: The actual expected type is `React.Provider<EmotionCache>` but we use `Function` because
 * to make it work regardless of if you are using React 18 or React 19 type def.
 */
CacheProvider?: Function): {
    withAppEmotionCache: <AppComponent extends NextComponentType<any, any, any>>(App: AppComponent) => AppComponent;
    augmentDocumentWithEmotionCache: (Document: NextComponentType<any, any, any>) => void;
};
