import { configureStore } from '@reduxjs/toolkit';
import cmdbReducer from './cmdbSlice';
import usersReducer from '../../../store/usersSlice';

export const store = configureStore({
  reducer: {
    cmdb: cmdbReducer,
    users: usersReducer
  }
});

export type RootState = ReturnType<typeof store.getState>;
export type AppDispatch = typeof store.dispatch;

export default store;
