<?php

class Projects_model extends Cf_Model
{
    private $endpoint = '/build/projects';

    public function create($data)
    {
        return $this->getRestClient()->post($this->endpoint, $data);
    }

    public function update($id, $data)
    {
        return $this->getRestClient()->patch("{$this->endpoint}/$id", $data);
    }

    public function remove($id)
    {
        return $this->getRestClient()->delete("{$this->endpoint}/$id");
    }

    public function push($id)
    {
        return $this->getRestClient()->post("{$this->endpoint}/$id/sync", ['action' => 'push']);
    }

    public function localDeploy($id)
    {
        return $this->getRestClient()->post("{$this->endpoint}/$id/localDeploy");
    }

    // project might be deployed locally and through a git repo
    public function synchronize($id, $localDeploy = 'false')
    {
        return $this->getRestClient()->post("{$this->endpoint}/$id/configureVCS?localDeploy=$localDeploy");
    }

    public function vcsSynchronized($id)
    {
        return $this->getRestClient()->get("{$this->endpoint}/$id/configureVCS");
    }

    public function createLocal($data)
    {
        return $this->getRestClient()->post("{$this->endpoint}/empty", $data);
    }

    public function get($id)
    {
        return $this->getRestClient()->get("{$this->endpoint}/$id");
    }

    public function list($params)
    {
        $query = http_build_query($params);
        return $this->getRestClient()->get("{$this->endpoint}?$query");
    }

    public function getModules($id)
    {
        return $this->getRestClient()->get("{$this->endpoint}/$id/modules");
    }

    public function addModule($id, $name, $version)
    {
        return $this->getRestClient()->post("{$this->endpoint}/$id/modules/$name/", ['version' => $version]);
    }

    public function addModuleByUrl($id, $url)
    {
        return $this->getRestClient()->post("{$this->endpoint}/$id/modules-by-url", ['url' => $url]);
    }

    public function updateModule($id, $name, $version, $encodedName = 'false')
    {
        return $this->getRestClient()->patch("{$this->endpoint}/$id/modules/$name/?encodedName=$encodedName", ['version' => $version]);
    }

    public function removeModule($id, $name, $encodedName = 'false')
    {
        return $this->getRestClient()->delete("{$this->endpoint}/$id/modules/$name/?encodedName=$encodedName");
    }

    public function getModuleInput($id, $name, $encodedName = 'false')
    {
        return $this->getRestClient()->get("{$this->endpoint}/$id/modules/$name/input/?encodedName=$encodedName");
    }

    public function setModuleInput($id, $name, $data, $encodedName = 'false')
    {
        return $this->getRestClient()->post("{$this->endpoint}/$id/modules/$name/input/?encodedName=$encodedName", $data);
    }

    public function refresh($id)
    {
        return $this->getRestClient()->post("{$this->endpoint}/$id/refresh");
    }

    public function forcePull($id)
    {
        return $this->getRestClient()->post("{$this->endpoint}/$id/sync", ['action' => 'force-pull']);
    }

    public function rebase($id)
    {
        return $this->getRestClient()->post("{$this->endpoint}/$id/sync", ['action' => 'rebase']);
    }

    public function forceRebase($id)
    {
        return $this->getRestClient()->post("{$this->endpoint}/$id/sync", ['action' => 'force-rebase']);
    }

    public function defaultAction($id, $action)
    {
        return $this->getRestClient()->post("{$this->endpoint}/$id/default-action", ['action' => $action]);
    }
}
