/*jslint node: true */
/*jslint browser: true*/
/*jslint nomen: true*/
/*jslint es5: true */
/*global Class, MP_SITE_URL, angular*/
'use strict';

/*
 * Service for dashboards
 *
 **/


var DashboardServiceClass = Class.extend({
    DASHBOARDAPI_URL: MP_SITE_URL + '/dashboard/dashboardsapi',

    getdashboards: function (dashId) {
        var url, urlParams;
        url = this.DASHBOARDAPI_URL + '/dashboards/';

        urlParams = '';

        if (dashId !== undefined) {
            url += encodeURIComponent(dashId);
        }
        return this.$http.get(url, {cache: false});
    },

    savedashboard: function (dashObj) {
        var url;
        url = this.DASHBOARDAPI_URL + '/savedashboard/';
        delete dashObj['starting'];

        if (dashObj.id !== undefined) {
            url += encodeURIComponent(dashObj.id);
        }
        return this.$http.post(url, dashObj, {cache: false});
    },

    cloneDashboard: function (dashObj) {
        let url = this.DASHBOARDAPI_URL + '/cloneDashboard/';

        if (dashObj.id !== undefined) {
            url += encodeURIComponent(dashObj.id);
        }
        return this.$http.post(url, dashObj, {cache: false});
    },

    removedashboard: function (dashId) {
        var url;
        url = this.DASHBOARDAPI_URL + '/removedashboard/';
        if (dashId !== undefined) {
            url += encodeURIComponent(dashId);
        }
        return this.$http.post(url, {cache: false});
    },

    getselecteddashboard: function () {
        var url;
        url = this.DASHBOARDAPI_URL + '/userselected/';
        return this.$http.get(url, {cache: false});
    },

    setselecteddashboard: function (dashId) {
        var url;
        url = this.DASHBOARDAPI_URL + '/selecteduser/';
        if (dashId !== undefined) {
            url += encodeURIComponent(dashId);
        }
        return this.$http.post(url, {cache: false});
    },

    resetselecteddashboards: function (dashId) {
        var url;
        url = this.DASHBOARDAPI_URL + '/resetselected/';
        if (dashId !== undefined) {
            url += encodeURIComponent(dashId);
        }
        return this.$http.post(url, {cache: false});
    },

    addwidget: function (widgetId) {
      var url;
      url = this.DASHBOARDAPI_URL + '/addwidget/';
      if (widgetId !== undefined) {
            url += encodeURIComponent(widgetId);
      }
      return this.$http.post(url, {cache: false});
    },

    deletewidget: function (widgetId) {
      var url;
      url = this.DASHBOARDAPI_URL + '/deletewidget/';
      if (widgetId !== undefined) {
            url += encodeURIComponent(widgetId);
      }
      return this.$http.post(url, {cache: false});
    },

    reorderwidgets: function (widgets, dashId) {
      var url;
      url = this.DASHBOARDAPI_URL + '/reorderwidgets/';
      if (dashId !== undefined) {
          url += encodeURIComponent(dashId);
      }
      return this.$http.post(url, widgets, {cache:false});
    },

    getUserRoles: function () {
      const url = this.DASHBOARDAPI_URL + '/user_roles/';
      return this.$http.get(url);
    }
  });

(function () {
    var dashboardServiceProvider = Class.extend({
        instance: new DashboardServiceClass(),
        $get: ['$http', '$rootScope', function ($http, $rootScope) {
            this.instance.$http = $http;
            this.instance.$rootScope = $rootScope;
            return this.instance;
        }]
    });

    angular.module('dashboardServiceModule', [])
        .provider('dashboardService', dashboardServiceProvider);
}());