<base href="/groups/">
<div ng-app="groupsApp" id="ng-app">
    <div id="groupsApp" class="contentWrapper" ng-view></div>

    <script type="text/ng-template" id="removeGroup.html">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal"  ng-click="close()">
                <i class="bi bi-x"></i>
            </button>
            <h2>Remove group</h2>
        </div>
        <div class="modal-body">
            Are you sure you want to delete the "{{ group.name }}" group?
            <span ng-if="isShared">Note that this is a shared group, and deleting it will delete data and module input. This process cannot be undone.</span>
        </div>
        <div class="modal-footer">
            <button class="btn btn-large btn-danger pull-right" ng-click="remove()">
                Remove
            </button>
            <button class="btn btn-large btn-info pull-left" type="button" class="close" data-dismiss="modal"
                     ng-click="close()">
                Cancel
            </button>
        </div>
    </script>

    <script type="text/ng-template" id="duplicateGroup.html">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal"  ng-click="close()">
                <i class="bi bi-x"></i>
            </button>
            <h2>Duplicate group</h2>
        </div>
        <div class="modal-body">
            <div class="question">What type of group do you want to make?</div>
            <div>
                <div>
                    <label>
                        <input type="radio" ng-model="data.type" name="groupType" value="personal"/>
                        <div>
                            <span>Personal group</span>
                            <div>
                                For you to use in reports & filters. Does not include data and module input.
                            </div>
                        </div>
                    </label>
                </div>
                <div>
                    <label ng-init="sharedAllowed=<?= isActionAllowed('host-groups-shared.post') ? 'true' : 'false' ?>"
                           ng-class="{disabled: !sharedAllowed}">
                        <input type="radio" ng-disabled="!sharedAllowed" ng-model="data.type" name="groupType"
                               value="shared"/>
                        <div>
                            <span>Shared group</span>
                            <div>
                                For use by everyone. Includes data and module input.
                            </div>
                        </div>
                    </label>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button class="btn btn-large btn-primary pull-right" ng-click="duplicate()">
                Confirm
            </button>
            <button class="btn btn-large btn-info pull-left" type="button" class="close" data-dismiss="modal"
                     ng-click="close()">
                Cancel
            </button>
        </div>
    </script>
</div>
