<?php
if (!empty($sys_messages))
{
    foreach ($sys_messages as $type => $txt)
    {
        echo '<div class="alert ' . $type . '">' . $txt . '</div>';
    }
}
else
{
    ?>
    <div>

        <form class="form-search">

    <?php if (isActionAllowed('role.create'))
    {
        ?>
            <a style="margin-left:0;" class="btn btn-primary btn-large" id="add_role" href="<?php echo site_url("auth/manage_role/create") ?>" form="role">Add role</a>
        <?php } ?>
    </form>

    <?php
    if (!empty($roles))
    {
        ?>
            <table class="table table-horizontal table-hover">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Description</th>
                        <th tooltip="">Default role <i rel="tooltip" class="CFE-context-help help icon-question-sign"  data-placement="left" title="" data-original-title="Apply role to new users"></i></th>
                    <?php if (isActionAllowed('role.update') || isActionAllowed('role.delete'))
                    {
                        ?> <th class="actions right">Actions</th> <?php } ?>
                    </tr>
                </thead>
                <tbody>
        <?php
        foreach ((array) $roles as $role)
        {
            ?>
                <tr>
                    <td><?php echo isset($role['id']) ? getCuttedText($role['id'], 5, 60) : getCuttedText($role['displayname'],5,60) ?></td>
                    <td><?php if (array_key_exists('description', $role)) echo $role['description'] ?></td>
                    <td><input type="checkbox" class="is_default_role"  <?php if(isset($defaultRole['name']) && $defaultRole['name'] == $role['id']) { ?> checked="checked" <?php } ?> value="<?= htmlspecialchars($role['id']) ?>"></td>

                        <?php
                        $inbuiltRoles = array('admin','cf_remoteagent');

                        if (in_array($role['id'] , $inbuiltRoles) === false)
                        {
                            ?>
                            <td class="right">
                                <?php if (isActionAllowed('role.update')) { ?>
                                <a href="<?php echo site_url("auth/manage_role/edit") . "/" . rawurlencode($role['id']) ?>" class="edit edit_role" title="edit role" form="role"></a>
                                <?php } ?>
                                <?php if (isActionAllowed('role.delete')) { ?>
                                <a href="<?php echo site_url("auth/delete_role/") . "/" . rawurlencode($role['id']) ?>" class="remove" entityName="role" action-link="/auth/manage_role" title="remove role"></a>
                                <?php } ?>
                            </td>
                            <?php
                        } else {
                            ?> <td></td><?php
                        }
                 ?>

                </tr>
                <?php } ?>
                </tbody>
            </table>
            <?php
            }
            else
            {
                ?>
            <div id="infoMessage">
                <?= $this->lang->line('nothing_found'); ?>
            </div>
    <?php } ?>
    </div>
<?php } ?>

<script>
    $('.is_default_role').change(function(){
        let name = $(this).is(':checked') ? $(this).attr('value') : '';
        $('.is_default_role').not(this).removeAttr('checked');
        $.ajax('/auth/setDefaultRole/' + name)
    });
</script>