<!DOCTYPE html>
<html lang="en">
<?php $this->load->view('auth/head.php'); ?>

<body>
<div class="login-wrapper">
    <div id="login">
        <div class="login-box relative center reset-password">
            <div class="absoluteCentered" style="width: 90%">
                <div style="padding-bottom: 2px">
                    <h2>Password reset</h2>
                    <p class="margin-bottom">
                        Enter the code or click the link from the email.
                    </p>  
                </div>
                <?php if (isset($message)) { ?>
                    <div class="alert <?= htmlspecialchars($message['type']) ?>"><?= htmlspecialchars($message['content']) ?></div>
                <?php } ?>
                <?php echo form_open('auth/reset-password/confirm', ['class' => 'form-horizontal', 'method' => 'GET', 'id' => 'reset-password']); ?>
                <div class="control-group">
                    <label class="control-label" for="token">Code:</label>
                    <div class="controls">
                        <input id="token" type="text" name="token" class="input-xlarge" value="<?= $token ?? '' ?>"/>
                    </div>
                </div>
                <div class="margin-top">
                    <div class="controls">
                        <button type="submit" id="reset"
                                class="btn btn-large btn-primary float-right margin-left-small">
                            Reset password
                        </button>
                        <a href="<?php echo site_url('login'); ?>" class="btn btn-large btnCancel float-right"
                           type="button">Cancel</a>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
</div>
<?php $this->carabiner->display('login'); ?>
<script>
    document.querySelector('#reset-password').addEventListener('submit', () => {
        document.querySelector('#reset').setAttribute('disabled', 'disabled');
        common.globalSpinner.show();
    });
</script>
</body>
</html>
