'use strict';

var hostInfoApp = angular.module('hostInfoApp',
    [
        'ngSanitize',
        'ngRoute',
        'notifications',
        'ui.bootstrap',
        'ngCookies',
        'cmdbServiceServiceModule',
        'hubManagementServiceModule',
        'customFilter',
        'cmdbDirectivesModule'
    ]
);

hostInfoApp.config([
    '$httpProvider',
    '$qProvider',
    function ($httpProvider, $qProvider) {
        //This header was removed from recent version of angular.
        // PHP looks at this header to separate request between regular and AJAX.
        $httpProvider.defaults.headers.common["X-Requested-With"] = 'XMLHttpRequest';
        // IE fix to prevent caching
        $httpProvider.defaults.headers.common["If-Modified-Since"] = 0;
        // ShowJson modal dialog has possibly unhandled rejections when closed
        // here we squash the error reporting in js console as the root cause is tricky to find
        $qProvider.errorOnUnhandledRejections(false);
    }
]);
