import type { CSSObject, Css, Cx } from "./types";
import type { EmotionCache } from "@emotion/cache";
export declare type Tss<Context extends Record<string, unknown>, Params extends Record<string, unknown>, RuleNameSubsetReferencableInNestedSelectors extends string, PluginParams extends Record<string, unknown>, ExcludedMethod extends "withParams" | "withName" | "withNestedSelectors" = never> = Omit<{
    create: <RuleName extends string>(cssObjectByRuleNameOrGetCssObjectByRuleName: Tss.CssObjectByRuleNameOrGetCssObjectByRuleName<Context, Params, RuleNameSubsetReferencableInNestedSelectors, RuleName>) => Tss.UseStyles<Context, Params, RuleName, PluginParams>;
    withParams: <Params extends Record<string, unknown>>() => Tss<Context, Params, RuleNameSubsetReferencableInNestedSelectors, PluginParams, ExcludedMethod | "withParams">;
    withName: (name: string | Record<string, unknown>) => Tss<Context, Params, RuleNameSubsetReferencableInNestedSelectors, PluginParams, ExcludedMethod | "withName">;
    withNestedSelectors: <RuleNameSubsetReferencableInNestedSelectors extends string>() => Tss<Context, Params, RuleNameSubsetReferencableInNestedSelectors, PluginParams, ExcludedMethod | "withNestedSelectors">;
}, ExcludedMethod>;
declare type VoidAllowedIfCanBeEmpty<T extends Record<string, unknown>> = Record<never, unknown> extends T ? void | T : T;
export declare namespace Tss {
    type UseStylesReturn<Context extends Record<string, unknown>, RuleName extends string> = ([RuleName] extends [never] ? {} : {
        classes: Record<RuleName, string>;
    }) & {
        css: Css;
        cx: Cx;
    } & Context;
    type UseStyles<Context extends Record<string, unknown>, Params extends Record<string, unknown>, RuleName extends string, PluginParams extends Record<string, unknown>> = (params: VoidAllowedIfCanBeEmpty<Params & PluginParams & {
        classesOverrides?: Record<string, string | undefined>;
    }>) => UseStylesReturn<Context, RuleName>;
    type CssObjectByRuleNameOrGetCssObjectByRuleName<Context extends Record<string, unknown>, Params extends Record<string, unknown>, RuleNameSubsetReferencableInNestedSelectors extends string, RuleName extends string> = ((params: Context & Params & ([RuleNameSubsetReferencableInNestedSelectors] extends [never] ? {} : {
        classes: Record<RuleNameSubsetReferencableInNestedSelectors, string>;
    })) => Record<RuleName | RuleNameSubsetReferencableInNestedSelectors, CSSObject>) | Record<RuleName, CSSObject>;
    type UsePlugin<Context extends Record<string, unknown>, PluginParams extends Record<string, unknown>> = (params: {
        classes: Record<string, string>;
        cx: Cx;
        css: Css;
        name: string | undefined;
        idOfUseStyles: string;
    } & Context & PluginParams) => {
        classes?: Record<string, string>;
        cx?: Cx;
        css?: Css;
    };
}
export declare function createTss<Context extends Record<string, unknown>, PluginParams extends Record<string, unknown>>(params: {
    useContext: () => Context;
    usePlugin?: Tss.UsePlugin<Context, PluginParams>;
    cache?: EmotionCache;
}): {
    tss: Tss<Context, Record<never, unknown>, never, PluginParams, never>;
};
export {};
