<?php

class Welcome extends Cf_Controller
{

    function __construct()
    {
        parent::__construct();
        parse_str($_SERVER['QUERY_STRING'], $_GET);
        $this->load->helper('form');
        $this->load->library(array('table', 'cfe_table'));
    }

    function index()
    {

        // redirect to 1st  app in the list
        $this->load->model('apps_model');
        $apps = $this->apps_model->getFrontendApps();
        if (!empty($apps))
        {
            $firstApp = $apps[0];
            $url = $firstApp['url'];
            redirect($url);
        }
        else
        {
            // fallback
            redirect('engineering');
        }

    }

    function search()
    {
        $params = $this->uri->uri_to_assoc(3);
        redirect('/search/' . $this->uri->assoc_to_uri($params));
    }
}

/* End of file welcome.php */
/* Location: ./system/application/controllers/welcome.php */