<?php

if (!function_exists('create_host_link_element')) {

    /**
     * Create element with link for host
     * @param string $hostKey
     * @param string $hostName
     * @param bool $targetBlank
     * @return string
     */
    function create_host_link_element($hostKey, $hostName, $targetBlank = true)
    {
        return anchor('/hosts/' . $hostKey, $hostName == '' ? $hostKey : $hostName, 'onclick="event.stopPropagation()" '.($targetBlank ? 'target="_blank"' : ''));
    }

    /**
     * Create additional menu links
     *
     * @return string
     */
    function createAdditionalMenuLinks()
    {
        $items = '';
        $files = array_filter(scandir(FCPATH . '/application/views/extraDocs'), function($item) {
            return !is_dir('../pages/' . $item) && pathinfo($item, PATHINFO_EXTENSION) == 'html';
        });

        foreach ($files as $file) {
            $name = extractHtmlFileName($file);
            $items .= ' <li>
                    <a href="' . site_url('docs/extra/' . urlencode($file)) .'">
                    <div class="icon-wrap"><i class="icon-info-sign margin-right"></i></div>
                    '. $name .'
                    </a>
                </li>';
        }

        return $items == '' ? '' :  '<li class="divider"></li>'. $items;
    }

    function extractHtmlFileName($file)
    {
      $name = pathinfo($file, PATHINFO_FILENAME);
      return ucfirst(str_replace('_', ' ', $name));
    }

}

function createTableFromApiResponse($data, $type = false)
{
    if (!isset($data['header']) && !isset($data['rows'])) {
        log_message('debug', 'createTableFromApiResponse argument is wrong');
        return 'Table cannot be loaded';
    }

    $table = '<table class="table table-bordered float-left margin-top"><thead><tr>';
    foreach ($data['header'] as $header) {
        $table .= '<th>' . $header['columnName'] . '</th>';
    }
    $table .= '</tr></thead><tbody>';

    foreach ($data['rows'] as $row) {
        $table .= '<tr>';
        foreach ($row as $index => $value) {
            $value = is_array($value) ? implode(', ', $value) : $value;
            $pin = ($type !== false && $index == 0)  ?
                 "<i pin-type='$type' pin-name='$value' class='create-pin'></i>" :
                 "";
            $table .= "<td>$value $pin</td>";
        }
        $table .= '</tr>';
    }

    $table .= ' </tbody></table>';

    return $table;
}

function getWidgetStyles($element, $defaultHeight, $defaultWidth)
{
    return "ng-style=\"{
        'height' : widget.payload.size.$element.height ? widget.payload.size.$element.height : $defaultHeight,
        'width' : widget.payload.size.$element.width ? widget.payload.size.$element.width : $defaultWidth
        }\"";
}
