<?php

class TourGuide_model extends Cf_Model {

    public function changeSeenTourByUserName( $userName, $value ) {
        try {
            $query = "UPDATE users SET seen_tour = ? WHERE username = ?";

            return $this->db->query( $query, [$value == true ? 1 : 0, $userName] );
        } catch ( Exception $e ) {
            log_message( 'error', $e->getMessage() . " " . $e->getFile() . " line:" . $e->getLine() );
            throw $e;
        }
    }

    public function getSeenTourByUserName( $userName ) {
        try {
            $query = "SELECT seen_tour FROM users WHERE username = ?";

            return $this->db->query( $query, [$userName] )->row();
        } catch ( Exception $e ) {
            log_message( 'error', $e->getMessage() . " " . $e->getFile() . " line:" . $e->getLine() );
            throw $e;
        }
    }

}