<div id="welcomeGuide" class="modal modal-big hide fade span10">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" ><i class="bi bi-x"></i></button>
        <h3>Introduction to new MISSION PORTAL features</h3>
    </div>

    <div class="modal-body">
        <div class="step-image"><img src="" alt="" /></div>
        <div class="step step-num1">
            <p><br />The CFEngine Mission Portal now has a <strong>completely new design</strong>!</p>
        </div>
        <div class="step step-num2 hide">
            <p>We have introduced a new way to filter the data we display in graphs and reports. You can now choose between three alternatives:</p>
            <ul class="unstyled">
            <li><strong>All:</strong> Navigation Tree, graphs, reports and events will contain data from all promises in you policy.</li>
            <li><strong>User:</strong> Navigation Tree, graphs, reports and events will contain data from promises that users in your organization have added.</li>
            <li><strong>System:</strong> Navigation Tree, graphs, reports and events will contain data from CFEngine system promises (labeled with a promise handle prefix cfe_internal in the default policies)</li>
            </ul>
        </div>
        <div class="step step-num3 hide">
            <p>CFEngine Enterprise now comes with a first version of an <strong>SQL based reporting engine</strong>. You can build your queries with the help of a wizard, or hand craft SQL queries yourself if you prefer. You can save your queries, and schedule automatic reports. All from within the Mission Portal or via our Enterprise API if you prefer.</p>
        </div>
        <div class="step step-num4 hide">
            <div class="row-fluid">
                <p class="span6">The <strong>navigation tree</strong> inside the host app has received a make-over. You can create custom trees more easily based on the standard classes, or the ones you have defined in your policy. We have prepared a standard tree that organizes your hosts by OS to get you started.</p>
                <p class="span6">Users can <strong>log into</strong> the Mission Portal using credentials based on LDAP or Active Directory, or with accounts specifically created within the Mission Portal. Admins can configure all details in the settings.</p>
            </div>
        </div>
        <div class="step step-num5 hide">
            <p>The new Mission Portal now comes with a preview into our future apps. You can enable our <strong>beta apps</strong> in the Mission Portal's admin settings to take a look, and make sure to <a href="mailto:feedback@cfengine.com">let us know what you think</a>!</p>
            <p>We added some <strong>analytics</strong> to the Mission Portal to learn more about how our users interact with it, so we can get the next release even closer to what you need. The analytics data we collect is anonymous, and it is turned off by default which means you control the data you send us. You can turn them on in and download collected data in the settings as well.</p>
        </div>
    </div>

    <div class="modal-footer">
        <div class="pull-left muted">(<span id="step-count"></span>/<span id="step-tot"></span>)</div>
        <a href="#" class="btn btn-primary hide prev">Prev</a>
        <a href="#" class="btn btn-primary next">Next</a>
        <a href="#" class="btn btn-success finish hide" data-dismiss="modal">Done</a>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function(){

        var count = 1;
        var tot = 5;
        var image_root = '<?php echo base_url(); ?>images/welcome_guide/';

        showStep();
        $("#welcomeGuide .next").click(function(){nextStep()});
        $("#welcomeGuide .prev").click(function(){prevStep()});
        $('#welcomeGuide .close, #welcomeGuide .finish').click(function(){hideWelcomeGuide()});

        function nextStep(){
            count++;
            showStep();
            $("#welcomeGuide .prev").show();

            if(count>=tot){
                $("#welcomeGuide .next").hide();
                $("#welcomeGuide .finish").show();
            }
        }

        function prevStep(){
            count--;
            showStep();
            $("#welcomeGuide .next").show();
            $("#welcomeGuide .finish").hide();

            if(count<=1){
                $("#welcomeGuide .prev").hide();
            }
        }

        function showStep(){
            $("#welcomeGuide .step-image img").attr('src',image_root+'step-num'+count+'.png');
            $("#step-count").html(count);
            $("#step-tot").html(tot);
            $("#welcomeGuide .step").hide();
            $("#welcomeGuide .step-num"+count).show();

        }

        function hideWelcomeGuide(){
            $.cookie("hide_welcome_guide", "true", { expires: 20*365 });
        }
    });
</script>