/*jslint node: true */
/*jslint browser: true*/
/*jslint nomen: true*/
/*global Class, MP_SITE_URL, angular*/
'use strict';
/*
 * Service for autocomplete
 *
 **/


var AutocompleteServiceClass = Class.extend({
    AUTOCOMPLETE_URL : MP_SITE_URL + '/autocomplete/load',
    AUTOCOMPLETE_VARIABLES_URL : MP_SITE_URL + '/autocomplete/variables',
    /**
     * @param <string> inputType  - host, promise, bundle
     * @param <string> inputValue - hostname(ubuntu1) -
     */
    load: function (inputType, inputValue) {
        var type = '', value = '', url = '';
        type  = encodeURIComponent(inputType);
        value = encodeURIComponent(inputValue);

        url =  this.AUTOCOMPLETE_URL + '/' + type + '/' + value;


        return this.$http.get(url, {
            cache: false
        }).then(
            function (result) {
                return result.data;
            },
            function (error) {
                return [];
            }
        );
    },
    /*
     *
     * Special function to provide autocomplete for variables table
     *
     */
    //TODO: this actualy returns values for variables
    loadVariables: function (variableName, variableValue) {
        var type = '', value = '', url = '';

        if (variableName === undefined || variableName === '' || variableValue === '') {
            return;
        }

        type  = encodeURIComponent(variableName);
        value = encodeURIComponent(variableValue);

        if (type === '' || value === '') {
            return;
        }


        url =  this.AUTOCOMPLETE_VARIABLES_URL + '/' + type + '/' + value;


        return this.$http.get(url, {
            cache: false
        }).then(
            function (result) {
                return result.data;
            },
            function (error) {
                return [];
            }
        );
    }
});

(function () {
    var autocompleteServiceProvider = Class.extend({
        instance: new AutocompleteServiceClass(),
        $get: ['$http', function ($http) {
            this.instance.$http = $http;
            return this.instance;
        }]
    });

    angular.module('autocompleteServiceModule', [])
        .provider('autocompleteService', autocompleteServiceProvider);
}());