#!/bin/bash
set -e
echo "Checking for cf-agent"
/var/cfengine/bin/cf-agent --version
echo "      [OK]"
if [[ ! -f /var/cfengine/policy_server.dat ]]; then
    echo -n "Bootstrapping to '$1'"
    /var/cfengine/bin/cf-agent --bootstrap $1 && echo "     [OK]"
fi

# exit here if running on CFEngine 3.18.x+
minor_version="$(/var/cfengine/bin/cf-agent --version | awk -F. '{print $2; exit}')"
echo "version detected: [$minor_version]"
expr "$minor_version" ">=" 18 >/dev/null && exit 0

# The following is executed only for CFEngine 3.17 and lower
echo "applying quickhub optimisations"

if [[ -f /var/cfengine/inputs/promises.cf ]]; then
    echo -n "Activating update policy"
    /var/cfengine/bin/cf-agent -f update.cf &> /dev/null&& echo "     [OK]"
    echo -n "Activating main policy"
    /var/cfengine/bin/cf-agent &> /dev/null&& echo "     [OK]"
fi
# To get the hub to show itself more quickly in the UI we go ahead and perform
# a collection
if [[ -x /var/cfengine/bin/cf-hub ]]; then
    /var/cfengine/bin/cf-hub --query rebase --query-host $1 &> /dev/null
    echo "Installing cron job to scan for new hosts and populate Mission Portal more quickly."
    echo "* * * * * root /bin/bash /vagrant/scripts/quickhub.sh" > /etc/cron.d/quickhub
fi
exit 0
