## Migration tools
This tool can be used typically on a running hub or possibly on a development machine. The paths involved will be different for each different environment.

#### 1. Go to "mission-portal"  folder where index.php is located.
On a development machine:
```bash
cd /path/to/mission-portal
```
On a hub:
```bash
cd /var/cfengine/httpd/htdocs
```

#### 2. Hosts generation
Depending on whether the php binary is in your PATH or not. On a hub you would likely need to
provide the complete path to the php binary such as ```/var/cfengine/httpd/php/bin/php```

```bash
if [ -e "./public/index.php" ]; then
  index_path="public/index.php"
elif [ -e "./index.php" ]; then
  index_path="index.php"
else
  echo error can not find index.php
#  exit 1
fi

/var/cfengine/httpd/php/bin/php $index_path data_generator/HostsGenerator generate \
  --hostKey=SHA=aa11bb \
  --hostCount=14 \
  --withSoftware \
  --withPromiseExecutions \
  --withPromiseLog \
  --withMeasurements \
  --withCMDB
```

```--hostKey```
: must be string like SHA=aa11bb. Hosts will have hostKey like %hostKey% + %sequence%

```--hostCount```
: count of hosts that will be generated

```--failCount```
: count of hosts with FAIL status

```--withSoftware```
: set 1 to generate software data (770 software packages per host)

```--withPromiseExecutions```
: set 1 to generate promise executions data (153 records per host)

```--withMeasurements```
: set 1 to generate monitoring data (6 records of ```CPU utilization (all)``` per host)

```--withPromiseLog```
: set 1 to generate promise log data (153 records per host)

```--withCMDB```
: set 1 to generate promise log data (1 record per host)


By default the following data is generated per host
- __lastseenhosts, 3 records per host
- __contexts, 11 records per host
- __variables, 58 records per host
- __agentstatus, 1 record per host

#### 2. Hosts simulation
Depending on whether the php binary is in your PATH or not. On a hub you would likely need to
provide the complete path to the php binary such as ```/var/cfengine/httpd/php/bin/php```

```bash
if [ -e public/index.php ]; then
  index_path="public/index.php"
elif [ -e public/index.php ]; then
  index_path="index.php"
else
  echo error can not find index.php
  exit 1
fi

php $index_path data_generator/HostsGenerator simulate --hostKey=SHA=aa11bb --hostCount=14 --withSoftware --withPromiseExecutions --interval=30 --verbose
```

```--hostKey```
: must be string like SHA=aa11bb. Hosts will have hostKey like %hostKey% + %sequence%

```--hostCount```
: count of hosts that will be generated

```--withSoftware```
: set 1 to generate software data

```--withPromiseExecutions```
: set 1 to generate promise executions data

```--interval``` (seconds)
: interval between data updating

```--failCount```
: count of hosts with FAIL status

```--insertLogs```
: insert logs into logs tables (emp.: softwarelog, variableslog). These logs tables significantly bloat database size.

```--verbose```
: show additional output information

By default simulate does the following
- updates __hosts.lastreporttimestamp
- updates __variables.changetimestamp
- updates __software.changetimestamp
- updates __promiseexecutions.changetimestamp
- updates __contexts.changetimestamp
- adds new entry in __monitoringmg with random values
- updates __agentstats.lastagentlocalexecutiontimestamp
- inserts log entries to match updates to __variables and __contexts in __variableslog, __contextslog
- adds 654 records to __softwarelog
