import yaml from 'js-yaml';

const FallbackComponent = ({ item, className }) => {
  let content = '';
  const { change } = item;
  if (Array.isArray(change)) {
    content = change
      .map(item => {
        if (typeof item === 'string') {
          return item;
        } else {
          return yaml.dump(item);
        }
      })
      .join('\n');
  }
  return <pre className={className}>{content}</pre>;
};

export default FallbackComponent;
