<?php

/**
 * Class NotRecentlyCollectedSqlBuilder
 */
class NotRecentlyCollectedSqlBuilder extends BaseHealthDiagnosticSqlBuilder
{
    /**
     * @var string
     */
    protected $sql = 'SELECT Hosts_view.HostKey 
                      FROM hosts Hosts_view 
                      WHERE Hosts_view.lastreporttimestamp < to_timestamp(\'%s\')
                      AND hostkey NOT IN (SELECT hostkey FROM health_diagnostics_dismissed WHERE username = \'%s\' AND report_type = \'%s\')';

    /**
     * @var string
     */
    protected $nonOverlappedSql;

    /**
     * @var string
     */
    protected $reportSql = 'SELECT h.Hostkey as key,h.hostname as "Host name", lastreporttimestamp as "Last report collected"  
                            FROM hosts h';


    /**
     * @return string
     */
    public function getSql(): string
    {
        $defaultTimeCheckForBlueHost = time() - 40 * 60;
        $timeCheckForBlueHost = isset($this->data['timeCheckForBlueHost']) ? $this->data['timeCheckForBlueHost'] : $defaultTimeCheckForBlueHost;
        //Add time to query to compare with lastreporttimestamp
        $this->sql = sprintf($this->sql, $timeCheckForBlueHost, $this->userName, BaseHealthDiagnostic::NOT_RECENTLY_COLLECTED_TYPE);
        return $this->sql;
    }

    /**
     * Extend report sql by adding where in (report sql).
     * It needs to include in report only needed hosts.
     *
     * @return string
     */
    public function getReportSql(): string
    {
        $this->reportSql = sprintf($this->reportSql . ' WHERE HostKey IN (%s)', $this->getNonOverlappedSql());

        return $this->reportSql;
    }


}
