<?php

/**
 * @uri /v2/changes/policy
 */
class ChangesPolicyV2 extends CfProtectedResource
{
    private function get_uri($page_num, $page_size)
    {
        $protocol = 'http://';
        if (isset($_SERVER['HTTPS']) && (strtolower($_SERVER["HTTPS"]) == "on")) {
            $protocol = 'https://';
        }

        $hostname = $_SERVER['SERVER_NAME'];
        if (!isset($hostname)) {
            $hostname = $_SERVER['SERVER_ADDR'];
        }

        $param_list = $_GET;
        $param_list['page'] = $page_num;
        $param_list['count'] = $page_size;
        $query = http_build_query($param_list);

        $uri = $protocol;
        $uri .= $hostname;
        $uri .= ':' . $_SERVER['SERVER_PORT'];
        $uri .= '/api/v2/changes/policy/';
        $uri .= '?' . $query;

        return $uri;
    }

    /**
     * @param $request
     *
     * @rbacName Get changes
     * @rbacGroup Changes API
     * @rbacAlias changesPolicyV2.get
     * @rbacAllowedByDefault
     *
     * @return Response
     * @throws ResponseException
     */
    public function get($request)
    {
        Utils::checkValidQueryParams(array(
            'hostkey',
            'include',
            'exclude',
            'logmessages',
            'policyfile',
            'bundlename',
            'promisehandle',
            'promiser',
            'promisetype',
            'stackpath',
            'promisees',
            'sort',
            'from',
            'to'));

        $to = Utils::queryParam('to', time());
        $from = Utils::queryParam('from', $to - (3600 * 24));


        $include = Utils::queryParam('include');
        $include = is_array($include) ? $include : [];

        $exclude = Utils::queryParam('exclude');
        $exclude = is_array($exclude) ? $exclude : [];

        $response = new Response($request);
        $payload = cfapi_changes_policy_get_v2(
            $this->username,
            $include,
            $exclude,
            Utils::queryParam('logmessages', ''),
            Utils::queryParam('policyfile', ''),
            Utils::queryParam('bundlename', ''),
            Utils::queryParam('promisehandle', ''),
            Utils::queryParam('promiser', ''),
            Utils::queryParam('promisetype', ''),
            Utils::queryParam('stackpath', ''),
            Utils::queryParam('promisees', ''),
            Utils::queryParam('hostkey', ''),
            $from,
            $to,
            DefaultParameters::page(),
            DefaultParameters::count(),
            Utils::queryParam('sort', '')
        );



        if ($payload) {

            /* Handle Pagination Cursors */
            $json_res = json_decode($payload, true);

            $json_res['next'] = null;
            if (DefaultParameters::page() * DefaultParameters::count() < $json_res['total']) {
                $json_res['next'] = $this->get_uri(
                    DefaultParameters::page() + 1,
                    DefaultParameters::count()
                );
            }

            $json_res['previous'] = null;
            if ((DefaultParameters::page() > 1) &&
                (!(DefaultParameters::page() + 1) * DefaultParameters::count() < $json_res['total'])) {
                $json_res['previous'] = $this->get_uri(
                    DefaultParameters::page() - 1,
                    DefaultParameters::count()
                );
            }

            $response->body = json_encode($json_res, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
            $response->code = Response::OK;
        } else {
            $response->code = Response::NOTFOUND;
        }

        return $response;
    }
}

/**
 * @uri /v2/changes/policy/count
 */
class ChangesPolicyCountV2 extends CfProtectedResource
{
    /**
     * @param $request
     *
     * @rbacName Get changes policy count
     * @rbacGroup Changes API
     * @rbacAlias changesPolicyCountV2.get
     * @rbacAllowedByDefault
     *
     * @return Response
     * @throws ResponseException
     */
    public function get($request)
    {
        Utils::checkValidQueryParams(array(
            'hostkey',
            'include',
            'exclude',
            'logmessages',
            'policyfile',
            'bundlename',
            'promisehandle',
            'promiser',
            'promisetype',
            'stackpath',
            'promisees',
            'from',
            'to'));

        $to = Utils::queryParam('to', time());
        $from = Utils::queryParam('from', $to - (3600 * 24));

        $include = Utils::queryParam('include');
        $include = is_array($include) ? $include : [];

        $exclude = Utils::queryParam('exclude');
        $exclude = is_array($exclude) ? $exclude : [];

        $response = new Response($request);
        $payload = cfapi_changes_policy_count_get_v2(
            $this->username,
            $include,
            $exclude,
            Utils::queryParam('logmessages', ''),
            Utils::queryParam('policyfile', ''),
            Utils::queryParam('bundlename', ''),
            Utils::queryParam('promisehandle', ''),
            Utils::queryParam('promiser', ''),
            Utils::queryParam('promisetype', ''),
            Utils::queryParam('stackpath', ''),
            Utils::queryParam('promisees', ''),
            Utils::queryParam('hostkey', ''),
            $from,
            $to
        );

        if ($payload) {
            $response->body = $payload;
            $response->code = Response::OK;
        } else {
            $response->code = Response::NOTFOUND;
        }

        return $response;
    }
}
