# Mission Portal

## Development Environment Setup

We provide a Vagrant file to spin up a full local development environment.

The Vagrant file requires full checkouts of the following repositories:

* `cfengine/core`
* `cfengine/enterprise`
* `cfengine/masterfiles`
* `cfengine/nova`

By default, the repositories are searched in the folder `/northern.tech`, you can override it by setting the `NTECH_ROOT` environment variable.

The Vagrant file also accepts the following environment variables:

* `DISTRO`: distribution to use, defaults to `debian/buster64`
* `BUILD_ALL`: rebuild all the CFengine components from the sources, defaults to `1`
* `BUILD_CORE`: rebuild `core` from the sources, defaults to `$BUILD_ALL`
* `BUILD_ENTERPRISE`: rebuild `enterprise` from the sources, defaults to `$BUILD_ALL`
* `BUILD_MASTERFILES`: rebuild `masterfiles` from the sources, defaults to `$BUILD_ALL`
* `BUILD_MP`: rebuild `mission-portal` from the sources, defaults to `$BUILD_ALL`
* `BUILD_NOVA`: rebuild `nova` from the sources, defaults to `$BUILD_ALL`
* `SETUP_MP`: run `make setup` in mission-portal to get MP working, defaults to `$BUILD_MP`
* `HUB_IP`: CFengine hub's IP address, defaults to `192.168.100.90`

To start the development environment, run:

```bash
$ vagrant box update
$ NTECH_ROOT=~/src/northerntech vagrant up
```

You can now access the Hub through your browser: https://localhost:8443

To rebuild all the components from source, you can reprovision the machine running:

```bash
$ vagrant up --provision
```

To develop the application, you can edit the files in the local check-outs, then run the Vagrant sync in a terminal:

```bash
$ vagrant rsync
```

You can enter the virtual machine running:

```
$ vagrant ssh
```

Inside the machine, you can rebuild the single components following the standard development workflow, e.g.:

```bash
$ cd /northern.tech/cfengine/core
$ make && sudo make install
```

In a similar way, you can update nova running:

```bash
$ cd /northern.tech/cfengine/nova
$ make && sudo make install
```

If you update and recompile the nova PHP modules, you need to restart Apache2 to see the changes, running:

```bash
$ sudo /var/cfengine/httpd/bin/apachectl stop
$ sudo /var/cfengine/httpd/bin/apachectl start
```

Note that if you wait after running the stop command, CFEngine might run the start command automatically.
In that case, you get a message saying it is already running.

The source code of mission portal is copied to `/var/cfengine/share/GUI`, and it is responsability of `cf-agent` to install it in the Apache2 document root. You can force the execution of the `cf-agent` to copy the files over runnning:

```bash
$ sudo /var/cfengine/bin/cf-agent
```

You can also directly modify the files in `/var/cfengine/httpd/htdocs/`.

When done, you can stop and optionally destroy the virtual machine running:

```
$ vagrant halt
$ vagrant destroy
```

To use Ubuntu instead of Debian, you can set the `DISTRO` environment variable at provisioning time:

```bash
$ DISTRO="ubuntu/focal64" vagrant up --provision
```

## Testing

See ci/README for information about running tests

### Install javascript dependencies

To install javascript dependencies run commands (require installed `npm` package):
```shell script
cd mission-portal/public/scripts
# install dependencies from npmjs
npm ci
# make a build of jquery-ui from sources
cd node_modules/jquery-ui
npm i --omit=dev
nodejs node_modules/grunt-cli/bin/grunt sizer concat
rm -rf ./node_modules
```

### Build React components
```shell script
cd mission-portal/public/scripts
# build components located in src/injectedComponents & src/entities
npm run build
# remove node_modules since the bundles are already built
rm -rf node_modules
```

### Install PHP dependencies

To install PHP dependencies, first install `composer` using instructions at https://getcomposer.org/download/, replacing the step

```shell script
php composer-setup.php
```

With

```shell script
mkdir -p $HOME/.local/bin    # this dir will often exist due to other software
php composer-setup.php --install-dir=$HOME/.local/bin --filename=composer
```

Or similar, to install composer as an executable in your `PATH`.

And then the following:

```shell script
  cd mission-portal
  # install dependencies from composer
  composer install
```

This process is automated here:
* https://github.com/cfengine/buildscripts/blob/master/build-scripts/bootstrap-tarballs#L89 for Jenkins

## Code Style and Linting

The project uses linting tools to maintain consistent code style across PHP and JavaScript files.

### PHP Code Style

PHP code style is enforced using PHP CS Fixer. You can check and fix code style issues using the following commands:

```shell script
cd mission-portal
# Check for code style issues (dry-run)
composer cs-check
# Automatically fix code style issues
composer cs-fix
```

Alternatively, you can use Prettier for PHP files:

```shell script
cd mission-portal/public/scripts
# Check PHP code style with Prettier
npm run lint:php
# Automatically fix PHP code style with Prettier
npm run lint-fix:php
```

### JavaScript/TypeScript Code Style

JavaScript and TypeScript code is linted using ESLint. To check and fix linting issues:

```shell script
cd mission-portal/public/scripts
# Check for linting issues
npm run lint
# Automatically fix linting issues
npm run lint-fix
```
