import { createAsyncThunk } from '@reduxjs/toolkit';
import Api from '@northern.tech/store/api/general-api';
import { Message } from '.';

export const sendMessage = createAsyncThunk(
  'chat/sendMessage',
  async ({ message, history } : { message: string, history: Message[] }, { signal, rejectWithValue }) => {
    const timeout = 60000; // 1 minute
    try {
      const { data } = await Api.post('/ai_reporter/ai_reporter_api/message', { message, history }, { timeout, signal });
      return data;
    } catch (error) {
      return rejectWithValue(error?.response?.data);
    }
  }
);
