<?php
require_once APPPATH . 'libraries/Cf_REST_Controller.php';

class Build_modules extends Cf_REST_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('build_app/modules_model');
    }

    public function modules_post()
    {
        try {
            $this->modules_model->refresh_list();
            $this->respond(204);
            return;
        } catch (Exception $exception) {
            log_message('error', 'Unable to refresh modules list. Error: ' . $exception->getMessage());
            throw $exception;
        }
    }

    public function modules_get()
    {
        try {
            $modules = $this->modules_model->list($_GET);
            $this->respond(200, $modules);
            return;
        } catch (Exception $exception) {
            log_message('error', 'Unable to get modules list. Error: ' . $exception->getMessage());
            throw $exception;
        }
    }

    public function module_get($name, $version = null)
    {
        try {
            $module = $this->modules_model->getByName($name, $version);
        } catch (HttpClient_NotFound $exception) {
            $this->respond(404, 'Module not found');
            return;
        } catch (Exception $exception) {
            log_message('error', 'Unable to get module. Error: ' . $exception->getMessage());
            throw $exception;
        }

        $this->respond(200, $module);
    }
}
