<?php

/**
 * Class WelcomeWizard_model
 */
class WelcomeWizard_model extends Cf_Model
{
    /**
     * @param $userName
     * @param $value
     *
     * @return mixed
     * @throws Exception
     */
    public function changeSeenWizardByUserName($userName, $value)
    {
        try {
            $query = 'UPDATE users SET seen_wizard = ? WHERE username = ?';
            return $this->db->query($query, [$value == true ? 1 : 0, $userName]);
        } catch (Exception $e) {
            log_message(log_level_for_exception($e), $e->getMessage() . ' ' . $e->getFile() . ' line:' . $e->getLine());
            throw $e;
        }
    }

    /**
     * @param $userName
     *
     * @return mixed
     * @throws Exception
     */
    public function getSeenWizardByUserName($userName)
    {
        try {
            $query = 'SELECT seen_wizard FROM users WHERE username = ?';
            return $this->db->query($query, [$userName])->row();
        } catch (Exception $e) {
            log_message(log_level_for_exception($e), $e->getMessage() . ' ' . $e->getFile() . ' line:' . $e->getLine());
            throw $e;
        }
    }
}
