/*jslint node: true */
/*jslint browser: true*/
/*jslint nomen: true*/
/*global Class, MP_SITE_URL, angular*/
'use strict';

/*
 * Service for events
 *
 **/


var EventsLogServiceClass = Class.extend({
        EVENTSLOG_URL: MP_SITE_URL + '/eventslogapi',
        geteventslog: function (data) {
            var url = this.EVENTSLOG_URL + '/events/';
            return this.$http.post(url, data, {cache: false});
        },

        getEventTypes: function () {
            var url = this.EVENTSLOG_URL + '/eventTypes/';
            return this.$http.get(url, {cache: false});
        },
        // only event log for current dashboard alerts
        getdasheventslog: function (data) {
            var url = this.EVENTSLOG_URL + '/dashevents/';
            return this.$http.post(url, data, {cache: false});
        }
    });

(function () {
    var eventsLogServiceProvider = Class.extend({
        instance: new EventsLogServiceClass(),
        $get: ['$http', function ($http) {
            this.instance.$http = $http;
            return this.instance;
        }]
    });

    angular.module('eventsLogServiceModule', [])
        .provider('eventsLogService', eventsLogServiceProvider);
}());