<?php

class Hubstatus extends Cf_Controller
{
    public function __construct()
    {
        parent::__construct();
    }

    public function status()
    {
        $this->load->helper(['form', 'url']);
        $this->load->library('form_validation');

        // Use webpack widgets bundle
        $requiredjs = [['dist/widgets.bundle.js', 'dist/widgets.bundle.js', false, false]];

        $this->carabiner->js($requiredjs);

        $data = [
            'title' => $this->lang->line('mission_portal_title') . ' - ' . $this->lang->line('hub_status'),
        ];

        $statusData = cfpr_replica_status();
        $arrayData = json_decode(mb_convert_encoding($statusData, 'UTF-8'), true);

        $data['replicationStatusData'] = $arrayData;
        $this->template->load('template', '/hubstatus/status', $data);
    }
}
