<?php

require_once APPPATH . '/libraries/Cf_REST_Controller.php';
class ProfileApi extends Cf_REST_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->username = $this->session->userdata('username');
        $this->load->model('ProfileModel');
    }

    public function user_get()
    {
        $data = $this->ProfileModel->getProfileData($this->username);
        $this->respond_ok(json_encode($data));
    }

    public function additional_data_get()
    {
        $key = $this->param('key');
        $data = $this->ProfileModel->getAdditionalData($this->username, $key);
        $this->respond_ok($data);
    }

    public function additional_data_post()
    {
        $requestData = json_decode($this->request->body, true) ?? [];
        $key = $requestData['key'] ?? '';
        $value = $requestData['value'] ?? false;
        if ($this->ProfileModel->isKeyAllowed($key)) {
            $this->ProfileModel->setAdditionalData($this->username, $key, $value);
        }
        $this->respond_ok();
    }
}
