<?php

class HttpsRedirectHandler
{
    private const DISABLE_REDIRECT_FLAG_PATH = '/opt/cfengine/flags/http_redirect_to_https.disabled';
    public function process()
    {
        /**
         * Skip if called in CLI (when you run `php index.php controller method` in the command line)
         * CLI constant is defined in the config.php
         */
        if (CLI === true || file_exists(self::DISABLE_REDIRECT_FLAG_PATH)) {
            return false;
        }

        if (!isset($_SERVER['HTTPS']) || $_SERVER['HTTPS'] !== 'on') {
            header('Content-Type: text/html; charset=UTF-8');
            echo '<script>location.replace("https://" + location.host + location.pathname + location.search + location.hash)</script> Redirecting...';
            exit();
        }
    }
}
