<button ng-click="saveAsGroupDialog()" ng-disabled="disabled" class="btn btn-secondary no-border">Save filter as group</button>

<script type="text/ng-template" id="saveFilterAsGroupDialog.html">
    <div class="modal-header">
        <button type="button" class="close" ng-click="close()"><i class="bi bi-x"></i></button>
        <h2 ng-if="!data.groupId">Save filter as group</h2>
        <h2 ng-if="data.groupId">Group created</h2>
    </div>
    <div class="modal-body">
        <form ng-if="!data.groupId" name="saveGroupForm" method="post" class="form-horizontal">
            <div class="control-group required">
                <label for="groupName" class="control-label">Name:</label>
                <div class="controls">
                    <input id="groupName" type="text" ng-model="data.name" ng-required="true" name="name" maxlength="100"/>
                </div>
            </div>
            <?php if (isActionAllowed('host-groups-shared.post')) { ?>
            <div class="control-group">
                <label for="isShared" class="control-label">
                    <span rel="tooltip"
                          class="CFE-context-help help"
                          data-placement="bottom"
                          data-original-title="Other users can see this group and if permitted data can be added.">
                        <i class="bi bi-question-circle-fill"> </i>
                     </span>
                    <span>Shared group:</span></label>
                <div class="controls">
                    <input type="checkbox" id="isShared" ng-model="data.isShared" name="isShared" />
                </div>
            </div>
            <?php } ?>
        </form>
        <div ng-if="data.groupId">
            The "{{ data.name }}" group was successfully created.
        </div>
    </div>
    <div class="modal-footer">
        <button class="btn btn-large" ng-click="close()">Close</button>
        <button ng-if="!data.groupId" class="btn btn-large btn-primary" ng-click="createGroup()" ng-disabled="saveGroupForm.$invalid">
            Confirm
        </button>
        <button ng-if="data.groupId" class="btn btn-large btn-primary" ng-click="viewGroup()">
            View group
        </button>
    </div>
</script>
