import React from 'react';

import VisibilityIcon from '@mui/icons-material/Visibility';
import VisibilityOffIcon from '@mui/icons-material/VisibilityOff';
import { IconButton, InputAdornment, TextField } from '@mui/material';

interface PasswordFieldProps {
  id: string;
  label: string;
  value?: string;
  onChange: (value: string) => void;
  error?: string;
  showPassword: boolean;
  onToggleVisibility: () => void;
}

export const PasswordField: React.FC<PasswordFieldProps> = ({ id, label, value, onChange, error, showPassword, onToggleVisibility }) => (
  <TextField
    id={id}
    name={id}
    label={label}
    type={showPassword ? 'text' : 'password'}
    autoComplete="new-password"
    className="input-xlarge"
    value={value}
    onChange={e => onChange(e.target.value)}
    error={!!error}
    fullWidth
    InputProps={{
      endAdornment: (
        <InputAdornment position="end">
          <IconButton onClick={onToggleVisibility} edge="end">
            {showPassword ? <VisibilityOffIcon /> : <VisibilityIcon />}
          </IconButton>
        </InputAdornment>
      )
    }}
  />
);
