<?php

class SettingsMailImporter extends BaseDataImporter
{
    public function isOnlyForAdmin(): bool
    {
        return true;
    }

    public function import($data)
    {
        $data = $this->ci->cf_encrypt->decryptByKey($data, $this->encryptionKey);
        $data = unserialize($data);

        foreach ($data as $setting) {
            $this->db->reset_query();
            $this->db->where('key', $setting['key']);
            $exist = $this->db->get('mail_settings');

            if ($exist->num_rows() == 0) {
                $this->db->insert('mail_settings', $setting);
            } else {
                $this->db->set('value', $setting['value']);
                $this->db->where('key', $setting['key']);
                $this->db->update('mail_settings');
            }
        }
        log_audit(
            actor: $this->username,
            objectType: AUDIT_LOG_TYPE_SETTINGS,
            action: AUDIT_LOG_ACTION_UPDATE,
            objectName: AUDIT_LOG_MAIL_SETTINGS_NAME,
            details: ['Updated mail settings via Import.'],
        );
    }
}
