<div class="project-home">
    <?= $this->load->view('/partials/aside') ?>
    <main class="build-modules build-modules-list">
        <?= $this->load->view('/partials/search') ?>

        <div class="modules-top">
            <p>Showing <b>{{ pagination.startItemIndex }}-{{ pagination.endItemIndex }}</b> of <b>{{pagination.total}}</b>
                <span ng-show="params.searchQuery">results for <b>{{ params.searchQuery }}</b></span>
            </p>
            <div>
                <div>
                    <form class="form-inline">
                        <span class="btn-group">
                            <button class="btn dropdown-toggle" data-toggle="dropdown">
                                {{order.by}}
                                <i class="bi bi-chevron-down"></i>
                            </button>
                            <ul class="dropdown-menu">
                                <li ng-hide="item == RELEVANCE && !params.searchQuery" ng-repeat="item in order.list">
                                    <a ng-click="order.by=item" href="javascript:void(0)">{{item}}</a>
                                </li>
                            </ul>
                        </span>
                    </form>
                </div>
            </div>
        </div>
        <div class="modules-list">
            <div class="modules-item" ng-repeat="module in modules">
                <div class="flex flex-space-between">
                    <div>
                        <div class="modules-item_name flex-grow">
                            <div class="flex flex--align_center">
                                <div class="modules-item_avatar">
                                    <img width="32" height="32" src="{{ module.author.image }}">
                                </div>
                                <div>
                                    <a href="/build/modules/{{ module.name }}" class="modules-item_title">
                                        {{ module.name }}
                                    </a>
                                    <div class="modules-item_author">by {{ module.author.name }}</div>
                                </div>
                            </div>
                        </div>
                        <p ng-bind-html="module.description" class="modules-item_description"></p>
                    </div>
                    <div class="right-info">
                        <div>Version: {{ module.version }}</div>
                        <div>Updated: {{ module.updated }}</div>
                        <div>Total downloads: {{ module.downloads }}</div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row-fluid float-left paginator_SE">
            <div class="span8">
                <div>
                    <form class="pull-left form-inline page-limit-selector" accept-charset="utf-8" method="post"
                          action="">
                        <span>Rows per page</span>
                        <span id="cfe-select-group-0" class="btn-group">
                            <button class="btn dropdown-toggle paginatorRowsPerPage_SE" data-toggle="dropdown">
                                {{pagination.perPage}}
                                <i class="bi bi-chevron-down"></i>
                            </button>
                            <ul class="dropdown-menu paginationRowsSelector_SE">
                                <li ng-repeat="item in rowsPerPageList">
                                    <a ng-click="pagination.perPage=item" href="javascript:void(0)">{{item}}</a>
                                </li>
                            </ul>
                        </span>
                    </form>
                </div>

                <div class="pagination inline-block">
                    <p>{{ pagination.startItemIndex }}-{{ pagination.endItemIndex }} of {{pagination.total}}</p>
                </div>
                <div class="pagination inline-block">
                    <ul class="pull-left">
                        <li>
                            <a ng-click="pagination.page = 1"
                               ng-class="{'disabled': pagination.page == 1}"
                               href="javascript:void(0)">
                                <i class="bi bi-chevron-bar-left"></i>
                            </a>
                        </li>
                        <li>
                            <a ng-click="pagination.page = ((pagination.page - 1) || 1)"
                               ng-class="{'disabled': pagination.page  <= 1}"
                               href="javascript:void(0)">
                                <i class="bi bi-chevron-compact-left"></i>
                            </a>
                        </li>
                        <li>
                            <a ng-class="{'disabled': pagination.page >= pagination.maxPage}"
                               ng-click="pagination.page = (pagination.page >= pagination.maxPage) ? pagination.maxPage : pagination.page+1"
                               href="javascript:void(0)"><i class="bi bi-chevron-compact-right"></i>
                            </a>
                        </li>
                        <li>
                            <a ng-class="{'disabled': pagination.page == pagination.maxPage}"
                               ng-click="pagination.page = pagination.maxPage"
                               href="javascript:void(0)">
                                <i class="bi bi-chevron-bar-right"></i></a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </main>
</div>
