<?php

include_once __DIR__ . '/BaseDiffConverter.php';

/**
 * Class DiffToArray
 */
class DiffToArray extends BaseDiffConverter
{
    /**
     * @param $diff
     *
     * @return string
     */
    public function convert($diff)
    {
        $diffData = $this->parseDiffData($diff);
        $response = $this->prepareResponse($diffData);
        return json_encode($response);
    }

    private function prepareResponse($diffData)
    {
        $result = [['Line number', 'Operation', 'Content']];

        foreach ($diffData as $row) {
            $result[] = [$row['lineNumber'], $row['operation'], $row['content']];
        }

        return $result;
    }
}
