<script type="text/ng-template" id="selectTable.html">
    <div class="modal-header">
        <button type="button" class="close" ng-click="close();"><i class="bi bi-x"></i></button>
        <h4>Table selecting</h4>
    </div>
    <div class="modal-body">
        <label class="checkbox" ng-show="SelectedTablesCount == 0">
            <input type="radio" ng-model="modalData.joinType" name="joinType" value="{{joinTypes.main}}" />
            <span>Main table</span>
            <span class="help-block">Define table as a main. Other tables will be added to this</span>
        </label>
        <label class="checkbox" ng-show="SelectedTablesCount > 0">
            <input type="radio" ng-model="modalData.joinType" name="joinType" value="{{joinTypes.left}}" />
            <span>Extend main table (left join)</span>
        </label>
        <label class="checkbox" ng-show="SelectedTablesCount > 0">
            <input type="radio" ng-model="modalData.joinType" name="joinType" value="{{joinTypes.inner}}" />
            <span>Include only common rows (inner join)</span>
        </label>
        <label class="checkbox" ng-hide="SelectedTablesCount == 0 || SelectedDCA[currentTableID].joinType == joinTypes.main">
            <input type="radio" ng-model="modalData.joinType" name="joinType" value="{{joinTypes.swap}}" />
            <span>Swap the table to be the main table</span>
            <span class="help-block">Current main table will be replaced with this and extended this table</span>
        </label>
    </div>

    <div class="modal-footer">
        <a class="btn btn-large pull-right btn-primary margin-left add-table" ng-disabled="!modalData.joinType" ng-click="applyTableSelecting(); close();" href="javascript:void(0)">Apply</a>
        <a class="btn btn-large pull-right" ng-click="close();" href="javascript:void(0)">Cancel</a>
    </div>
</script>

<script type="text/ng-template" id="selectMainTable.html">
    <div class="modal-header">
        <button type="button" class="close" ng-click="close();"><i class="bi bi-x"></i></button>
        <h4>Select a main table</h4>
    </div>
    <div class="modal-body">
       <h5>Select new main table:</h5>

        <ul class="unstyled">
            <li ng-repeat="(tableID, el) in SelectedDCA" ng-if="el.joinType !== joinTypes.main">
            <label class="checkbox" ng-show="SelectedTablesCount > 0">
                <input type="radio" ng-model="modalData.newMainTableId" name="joinType" checked="checked" value="{{tableID}}" />
                <span>{{tableID}}</span>
            </label>
            </li>
        </ul>
    </div>

    <div class="modal-footer">
        <a class="btn btn-large pull-right btn-primary  margin-left convert-table" ng-click="convertTableToMain(); close();" ng-disabled="modalData.newMainTableId == undefined" href="javascript:void(0)">Apply</a>
        <a class="btn btn-large pull-right" ng-click="close();" href="javascript:void(0)">Cancel</a>
    </div>
</script>

