<?php

require_once APPPATH . 'libraries/Cf_REST_Controller.php';

class DarkMode extends Cf_REST_Controller
{
    private $userName;

    public function __construct()
    {
        parent::__construct();
        $this->load->model('ProfileModel');
        $this->userName = $this->session->userdata('username');
    }

    public function update_post()
    {
        try {
            $enabled = (int) $this->input->post('enabled');
            $this->ProfileModel->setDarkMode($enabled, $this->userName);
            set_cookie('dark_mode', $enabled, 7200);
            respond_ok();
        } catch (Exception $e) {
            $msg = $e->getMessage();
            log_message('error', "Failed dark mode update, error: $msg");
            respond_internal_error($msg);
        }
    }
}
