/*jslint node: true */
/*jslint browser: true*/
/*jslint nomen: true*/
/*jslint es5: true */
/*global Class, MP_SITE_URL, angular*/
'use strict';

/*
 * Service for change reports
 *
 **/


var ChangesServiceClass = Class.extend({
    ADV_REPORTS_URL:  MP_SITE_URL + '/advancedreports',
    getChangesStats: function (queryData) {
        queryData.timezone = Intl.DateTimeFormat().resolvedOptions().timeZone;
        var data = $.param(queryData);
      return this.$http({
          method: 'POST',
          headers : {
              'Content-Type':'application/x-www-form-urlencoded; charset=UTF-8'
          },
          url: this.ADV_REPORTS_URL + '/changescount',
          data: data,
          cache: true
      });
    }
});


(function() {
    var changesServiceProvider = Class.extend({
        instance: new ChangesServiceClass(),
        $get: ['$http', function($http) {
            this.instance.$http = $http;
            return this.instance;
        }]
    });


    angular.module('changesServiceModule', [])
        .provider('changesService', changesServiceProvider);

}());