import Variable from '../components/types/variable/Create'
import Inventory from '../components/types/inventory/Create'
import Class from '../components/types/class/Create'
import Policy from '../components/types/policy/Create'

export const CMDB_ITEM_TYPES = {
  INVENTORY: 'inventory',
  POLICY_CONFIGURATION: 'policy_configuration',
  CLASS: 'class',
  VARIABLE: 'variable'
};

export const VARIABLE_TYPES = [{ value: "String", label: "String" }, { value: "array", label: "List" }, { value: "object", label: "Data container" }];
export const ITEM_TYPES = [
  {
    value: CMDB_ITEM_TYPES.INVENTORY,
    label: "Inventory attribute",
    component: ({ identifier, setCmdbItem, formRef, item, classes }) => <Inventory setCmdbItem={setCmdbItem} ref={formRef} identifier={identifier} item={item} classes={classes} />
  },
  {
    value: CMDB_ITEM_TYPES.POLICY_CONFIGURATION,
    label: "Policy configuration",
    component: ({ identifier, setCmdbItem, formRef, item, classes }) => <Policy setCmdbItem={setCmdbItem} ref={formRef} identifier={identifier} item={item} classes={classes} />
  },
  {
    value: CMDB_ITEM_TYPES.CLASS,
    label: "Class",
    component: ({ identifier, setCmdbItem, formRef, item, classes }) => <Class setCmdbItem={setCmdbItem} ref={formRef} identifier={identifier} item={item} classes={classes} />
  },
  {
    value: CMDB_ITEM_TYPES.VARIABLE,
    label: "Variable",
    component: ({ identifier, setCmdbItem, formRef, item, classes }) => <Variable setCmdbItem={setCmdbItem} ref={formRef} identifier={identifier} item={item} classes={classes} />
  },
];

export const TYPES_NAMES_MAP = {
  [CMDB_ITEM_TYPES.INVENTORY]: 'Inventory attribute',
  [CMDB_ITEM_TYPES.POLICY_CONFIGURATION]: 'Policy configuration',
  [CMDB_ITEM_TYPES.CLASS]: 'Class',
  [CMDB_ITEM_TYPES.VARIABLE]: 'Variable',
}
