<?php

class vitals_rest_model extends Cf_Model
{
    /**
     * Gets the sorted list of vitals for a given host
     * @param strng $username
     * @param string $hostkey
     * @return array
     */
    public function getVitalsList($username, $hostkey)
    {
        $json = $this->rest->get('/host/' . $hostkey . '/vital/');
        $returnArray = json_decode($json, true);
        return $returnArray;
    }

    /**
     * Returns data for magnified view in vitals
     * @param string $username
     * @param string $hostkey
     * @param string $observables
     * @param timestamp last updated date of the vitals
     * @return string JSON
     */
    public function getVitalsMagnifiedViewJson($username, $hostkey, $observables, $lastUpdated, $hourAgo = 6)
    {
        try {
            if (!$lastUpdated) {
                $lastUpdated = time();
            }

            $hoursBefore = $lastUpdated - $hourAgo * 60 * 60; // grab second last
            $to = $lastUpdated;
            $query = '/host/' . $hostkey . '/vital/' . $observables . '?from=' . $hoursBefore . '&to=' . $to;
            $json = $this->rest->get($query);
            $converted = json_decode($json, true);
            return json_encode($converted['data'][0]['values']);
        } catch (Exception $e) {
            throw $e;
        }
    }
}
