<?php
$ip = RandomGenerator::ip();
$os = RandomGenerator::os($i);

return [
    //Host name
    [
        'hostkey' => $hostKey,
        'namespace' => 'default',
        'bundle' => 'sys',
        'variablename' => 'fqhost',
        'variablevalue' => RandomGenerator::name(),
        'variabletype' => 'string',
        'comp' => 'default.sys.fqhost',
        'metatags' => '{inventory,source=agent,"attribute_name=Host name"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],
    //CPU logical cores
    [
        'hostkey' => $hostKey,
        'namespace' => 'default',
        'bundle' => 'sys',
        'variablename' => 'cpus',
        'variablevalue' => mt_rand(0, 10),
        'variabletype' => 'string',
        'comp' => 'default.sys.cpus',
        'metatags' => '{inventory,source=agent,"attribute_name=CPU logical cores"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],
    //OS
    [
        'hostkey' => $hostKey,
        'namespace' => 'default',
        'bundle' => 'sys',
        'variablename' => 'flavor',
        'variablevalue' => $os,
        'variabletype' => 'string',
        'comp' => 'default.sys.flavor',
        'metatags' => '{inventory,source=agent,attribute_name=none}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],
    [
        'hostkey' => $hostKey,
        'namespace' => 'default',
        'bundle' => 'inventory_os',
        'variablename' => 'description',
        'variablevalue' => $os,
        'variabletype' => 'string',
        'comp' => 'default.inventory_os.description',
        'metatags' => '{source=promise,inventory,attribute_name=OS}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],
    [
        'hostkey' => $hostKey,
        'namespace' => 'default',
        'bundle' => 'inventory_lsb',
        'variablename' => 'os',
        'variablevalue' => $os,
        'variabletype' => 'string',
        'comp' => 'default.inventory_lsb.os',
        'metatags' => '{source=promise,inventory,attribute_name=none}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],
    //Kernel Release
    [
        'hostkey' => $hostKey,
        'namespace' => 'default',
        'bundle' => 'sys',
        'variablename' => 'release',
        'variablevalue' => $i . '4.4.0-53-generic',
        'variabletype' => 'string',
        'comp' => 'default.sys.release',
        'metatags' => '{inventory,source=agent,"attribute_name=Kernel Release"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],
    //OS type
    [
        'hostkey' => $hostKey,
        'namespace' => 'default',
        'bundle' => 'sys',
        'variablename' => 'class',
        'variablevalue' => 'linux',
        'variabletype' => 'string',
        'comp' => 'default.sys.class',
        'metatags' => '{inventory,source=agent,"attribute_name=OS type"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],
    //IPv4 addresses
    [
        'hostkey' => $hostKey,
        'namespace' => 'default',
        'bundle' => 'cfe_autorun_inventory_ipv4_addresses',
        'variablename' => 'ipv4[' . $ip . ']',
        'variablevalue' => $ip,
        'variabletype' => 'string',
        'comp' => 'default.cfe_autorun_inventory_ipv4_addresses.ipv4[' . $ip . ']',
        'metatags' => '{source=promise,inventory,"attribute_name=IPv4 addresses"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],
    //Memory size (MB)
    [
        'hostkey' => $hostKey,
        'namespace' => 'default',
        'bundle' => 'cfe_autorun_inventory_memory',
        'variablename' => 'total',
        'variablevalue' => mt_rand(1000, 5000),
        'variabletype' => 'string',
        'comp' => 'default.cfe_autorun_inventory_memory.total',
        'metatags' => '{source=promise,inventory,"attribute_name=Memory size (MB)"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],
    //Uptime minutes
    [
        'hostkey' => $hostKey,
        'namespace' => 'default',
        'bundle' => 'sys',
        'variablename' => 'Uptime',
        'variablevalue' => mt_rand(1, 500000),
        'variabletype' => 'int',
        'comp' => 'default.sys.uptime',
        'metatags' => '{source=promise,inventory,"attribute_name=Uptime minutes"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],
    //Architecture
    [
        'hostkey' => $hostKey,
        'namespace' => 'default',
        'bundle' => 'sys',
        'variablename' => 'Architecture',
        'variablevalue' => 'x86_64',
        'variabletype' => 'slist',
        'comp' => 'default.sys.arch',
        'metatags' => '{source=promise,inventory,"attribute_name=Architecture"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],
    //BIOS vendor
    [
        'hostkey' => $hostKey,
        'namespace' => 'default',
        'bundle' => 'sys',
        'variablename' => 'BIOSvendor',
        'variablevalue' => 'BIOS vendor',
        'variabletype' => 'string',
        'comp' => 'default.cfe_autorun_inventory_dmidecode.dmi[bios-vendor]',
        'metatags' => '{source=promise,inventory,"attribute_name=BIOS vendor"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],
    //BIOS version
    [
        'hostkey' => $hostKey,
        'namespace' => 'default',
        'bundle' => 'sys',
        'variablename' => 'BIOSversion',
        'variablevalue' => 'BIOS version',
        'variabletype' => 'string',
        'comp' => 'default.cfe_autorun_inventory_dmidecode.dmi[bios-version]',
        'metatags' => '{source=promise,inventory,"attribute_name=BIOS version"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],
    //CPU model
    [
        'hostkey' => $hostKey,
        'namespace' => 'default',
        'bundle' => 'sys',
        'variablename' => 'CPUmodel',
        'variablevalue' => 'CPU model A' . mt_rand(0, 20),
        'variabletype' => 'string',
        'comp' => 'default.cfe_autorun_inventory_cpuinfo.cpu_model',
        'metatags' => '{source=promise,inventory,"attribute_name=CPU model"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],
    //System serial number
    [
        'hostkey' => $hostKey,
        'namespace' => 'default',
        'bundle' => 'sys',
        'variablename' => 'system-serial-number',
        'variablevalue' => 'System serial number ' . mt_rand(0, 20),
        'variabletype' => 'string',
        'comp' => 'default.cfe_autorun_inventory_dmidecode.dmi[system-serial-number]',
        'metatags' => '{source=promise,inventory,"attribute_name=System serial number"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],
    //System version
    [
        'hostkey' => $hostKey,
        'namespace' => 'default',
        'bundle' => 'Systemversion',
        'variablename' => 'Systemversion',
        'variablevalue' => 'System manufacturer ' . mt_rand(0, 20),
        'variabletype' => 'string',
        'comp' => 'default.cfe_autorun_inventory_dmidecode.dmi[system-version]',
        'metatags' => '{source=promise,inventory,"attribute_name=System version"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],

    //Disk free (%)
    [
        'hostkey' => $hostKey,
        'namespace' => 'default',
        'bundle' => 'sys',
        'variablename' => 'Diskfree',
        'variablevalue' => mt_rand(1, 99),
        'variabletype' => 'int',
        'comp' => 'default.cfe_autorun_inventory_disk.free',
        'metatags' => '{source=promise,inventory,"attribute_name=Disk free (%)"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],

    //CFEngine ID
    [
        'hostkey' => $hostKey,
        'namespace' => 'default',
        'bundle' => 'sys',
        'variablename' => 'key_digest',
        'variablevalue' => $hostKey,
        'variabletype' => 'string',
        'comp' => 'default.sys.key_digest',
        'metatags' => '{source=promise,inventory,"attribute_name=CFEngine ID"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],
    //CFEngine version
    [
        'hostkey' => $hostKey,
        'namespace' => 'default',
        'bundle' => 'sys',
        'variablename' => 'default.cfe_autorun_inventory_disk.free',
        'variablevalue' => '3.10.' . mt_rand(1, 99),
        'variabletype' => 'string',
        'comp' => 'default.sys.cf_version',
        'metatags' => '{source=promise,inventory,"attribute_name=CFEngine version"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],

    //Interfaces
    [
        'hostkey' => $hostKey,
        'namespace' => 'default',
        'bundle' => 'sys',
        'variablename' => 'Interfaces',
        'variablevalue' => '{"pop","imap"}',
        'variabletype' => 'slist',
        'comp' => 'default.sys.interfaces',
        'metatags' => '{source=promise,inventory,"attribute_name=Interfaces"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],

    //MAC addresses
    [
        'hostkey' => $hostKey,
        'namespace' => 'default',
        'bundle' => 'sys',
        'variablename' => 'MACaddresses',
        'variablevalue' =>
            '{"' .
            mt_rand(10, 99) .
            '-' .
            mt_rand(10, 99) .
            '-' .
            mt_rand(10, 99) .
            '-' .
            mt_rand(10, 99) .
            '-' .
            mt_rand(10, 99) .
            '-' .
            mt_rand(10, 99) .
            '","' .
            mt_rand(10, 99) .
            '-' .
            mt_rand(10, 99) .
            '-' .
            mt_rand(10, 99) .
            '-' .
            mt_rand(10, 99) .
            '-' .
            mt_rand(10, 99) .
            '-' .
            mt_rand(10, 99) .
            '"}',
        'variabletype' => 'slist',
        'comp' => 'default.sys.hardware_addresses',
        'metatags' => '{source=promise,inventory,"attribute_name=MAC addresses"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],

    //Ports listening
    [
        'hostkey' => $hostKey,
        'namespace' => 'default',
        'bundle' => 'sys',
        'variablename' => 'Portslistening',
        'variablevalue' =>
            '{"' .
            mt_rand(10, 10000) .
            '","' .
            mt_rand(10, 10000) .
            '","' .
            mt_rand(10, 10000) .
            '","' .
            mt_rand(10, 10000) .
            '","' .
            mt_rand(10, 10000) .
            '"}',
        'variabletype' => 'slist',
        'comp' => 'default.cfe_autorun_inventory_listening_ports.ports',
        'metatags' => '{source=promise,inventory,"attribute_name=Ports listening"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],

    //CPU physical cores
    [
        'hostkey' => $hostKey,
        'namespace' => 'default',
        'bundle' => 'sys',
        'variablename' => 'CPU_physical_cores',
        'variablevalue' => mt_rand(1, 10),
        'variabletype' => 'int',
        'comp' => 'default.cfe_autorun_inventory_cpuinfo.cpuinfo_physical_cores',
        'metatags' => '{source=promise,inventory,"attribute_name=CPU physical cores"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],
    //CPU sockets
    [
        'hostkey' => $hostKey,
        'namespace' => 'default',
        'bundle' => 'sys',
        'variablename' => 'CPUSockets',
        'variablevalue' => mt_rand(1, 1000),
        'variabletype' => 'int',
        'comp' => 'default.cfe_autorun_inventory_proc_cpuinfo.cpuinfo_physical_socket_inventory',
        'metatags' => '{source=promise,inventory,"attribute_name=CPU sockets"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],

    //System product name
    [
        'hostkey' => $hostKey,
        'namespace' => 'default',
        'bundle' => 'sys',
        'variablename' => 'SystemProductName',
        'variablevalue' => md5(mt_rand(1, 10022222220)),
        'variabletype' => 'string',
        'comp' => 'default.cfe_autorun_inventory_dmidecode.dmi[system-product-name]',
        'metatags' => '{source=promise,inventory,"attribute_name=System product name"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],

    //Solaris zone
    [
        'hostkey' => $hostKey,
        'namespace' => 'default',
        'bundle' => 'sys',
        'variablename' => 'solariszone',
        'variablevalue' => md5(mt_rand(1, 10022222220)),
        'variabletype' => 'string',
        'comp' => 'default.cfe_autorun_inventory_dmidecode.solariszone',
        'metatags' => '{source=promise,inventory,"attribute_name=Solaris zone"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],

    //Windows roles
    [
        'hostkey' => $hostKey,
        'namespace' => 'default',
        'bundle' => 'sys',
        'variablename' => 'Windowsroles',
        'variablevalue' => md5(mt_rand(1, 10022222220)),
        'variabletype' => 'string',
        'comp' => 'default.cfe_autorun_inventory_dmidecode.Windowsroles',
        'metatags' => '{source=promise,inventory,"attribute_name=Windows roles"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],

    //Virtual host
    [
        'hostkey' => $hostKey,
        'namespace' => 'default',
        'bundle' => 'sys',
        'variablename' => 'VirtualHost',
        'variablevalue' => md5(mt_rand(1, 10022222220)),
        'variabletype' => 'string',
        'comp' => 'default.cfe_autorun_inventory_dmidecode.VirtualHost',
        'metatags' => '{source=promise,inventory,"attribute_name=Virtual host"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],

    //Highest Service Pack
    [
        'hostkey' => $hostKey,
        'namespace' => 'default',
        'bundle' => 'sys',
        'variablename' => 'HighestServicePack',
        'variablevalue' => md5(mt_rand(1, 10022222220)),
        'variabletype' => 'string',
        'comp' => 'default.cfe_autorun_inventory_dmidecode.HighestServicePack',
        'metatags' => '{source=promise,inventory,"attribute_name=Highest Service Pack"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],

    //Highest Technology Level
    [
        'hostkey' => $hostKey,
        'namespace' => 'default',
        'bundle' => 'sys',
        'variablename' => 'HighestTechnologyLevel',
        'variablevalue' => md5(mt_rand(1, 10022222220)),
        'variabletype' => 'string',
        'comp' => 'default.cfe_autorun_inventory_dmidecode.HighestTechnologyLevel',
        'metatags' => '{source=promise,inventory,"attribute_name=Highest Technology Level"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],
    //Host name
    [
        'hostkey' => $hostKey,
        'namespace' => 'newdefault',
        'bundle' => 'sys',
        'variablename' => 'New fqhost',
        'variablevalue' => $hostKey,
        'variabletype' => 'string',
        'comp' => 'newdefault.sys.fqhost',
        'metatags' => '{inventory,source=agent,"attribute_name=New Host name"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],
    //CPU logical cores
    [
        'hostkey' => $hostKey,
        'namespace' => 'newdefault',
        'bundle' => 'sys',
        'variablename' => 'New cpus',
        'variablevalue' => mt_rand(0, 10),
        'variabletype' => 'string',
        'comp' => 'newdefault.sys.cpus',
        'metatags' => '{inventory,source=agent,"attribute_name=New CPU logical cores"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],
    //OS
    [
        'hostkey' => $hostKey,
        'namespace' => 'newdefault',
        'bundle' => 'sys',
        'variablename' => 'New flavor',
        'variablevalue' => $os,
        'variabletype' => 'string',
        'comp' => 'newdefault.sys.flavor',
        'metatags' => '{inventory,source=agent,attribute_name=New none}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],
    [
        'hostkey' => $hostKey,
        'namespace' => 'newdefault',
        'bundle' => 'inventory_os',
        'variablename' => 'New description',
        'variablevalue' => $os,
        'variabletype' => 'string',
        'comp' => 'newdefault.inventory_os.description',
        'metatags' => '{source=promise,inventory,attribute_name=New OS}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],
    [
        'hostkey' => $hostKey,
        'namespace' => 'newdefault',
        'bundle' => 'inventory_lsb',
        'variablename' => 'New os',
        'variablevalue' => $os,
        'variabletype' => 'string',
        'comp' => 'newdefault.inventory_lsb.os',
        'metatags' => '{source=promise,inventory,attribute_name=New none}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],
    //Kernel Release
    [
        'hostkey' => $hostKey,
        'namespace' => 'newdefault',
        'bundle' => 'sys',
        'variablename' => 'New release',
        'variablevalue' => $i . '4.4.0-53-generic',
        'variabletype' => 'string',
        'comp' => 'newdefault.sys.release',
        'metatags' => '{inventory,source=agent,"attribute_name=New Kernel Release"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],
    //OS type
    [
        'hostkey' => $hostKey,
        'namespace' => 'newdefault',
        'bundle' => 'sys',
        'variablename' => 'New class',
        'variablevalue' => 'linux',
        'variabletype' => 'string',
        'comp' => 'newdefault.sys.class',
        'metatags' => '{inventory,source=agent,"attribute_name=New OS type"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],
    //IPv4 addresses
    [
        'hostkey' => $hostKey,
        'namespace' => 'newdefault',
        'bundle' => 'cfe_autorun_inventory_ipv4_addresses',
        'variablename' => 'New ipv4[' . $ip . ']',
        'variablevalue' => $ip,
        'variabletype' => 'string',
        'comp' => 'newdefault.cfe_autorun_inventory_ipv4_addresses.ipv4[' . $ip . ']',
        'metatags' => '{source=promise,inventory,"attribute_name=New IPv4 addresses"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],
    //Memory size (MB)
    [
        'hostkey' => $hostKey,
        'namespace' => 'newdefault',
        'bundle' => 'cfe_autorun_inventory_memory',
        'variablename' => 'New total',
        'variablevalue' => mt_rand(1000, 5000),
        'variabletype' => 'string',
        'comp' => 'newdefault.cfe_autorun_inventory_memory.total',
        'metatags' => '{source=promise,inventory,"attribute_name=New Memory size (MB)"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],
    //Uptime minutes
    [
        'hostkey' => $hostKey,
        'namespace' => 'newdefault',
        'bundle' => 'sys',
        'variablename' => 'New Uptime',
        'variablevalue' => mt_rand(1, 500000),
        'variabletype' => 'int',
        'comp' => 'newdefault.sys.uptime',
        'metatags' => '{source=promise,inventory,"attribute_name=New Uptime minutes"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],
    //Architecture
    [
        'hostkey' => $hostKey,
        'namespace' => 'newdefault',
        'bundle' => 'sys',
        'variablename' => 'New Architecture',
        'variablevalue' => 'x86_64',
        'variabletype' => 'slist',
        'comp' => 'newdefault.sys.arch',
        'metatags' => '{source=promise,inventory,"attribute_name=New Architecture"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],
    //BIOS vendor
    [
        'hostkey' => $hostKey,
        'namespace' => 'newdefault',
        'bundle' => 'sys',
        'variablename' => 'New BIOSvendor',
        'variablevalue' => 'BIOS vendor',
        'variabletype' => 'string',
        'comp' => 'newdefault.cfe_autorun_inventory_dmidecode.dmi[bios-vendor]',
        'metatags' => '{source=promise,inventory,"attribute_name=New BIOS vendor"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],
    //BIOS version
    [
        'hostkey' => $hostKey,
        'namespace' => 'newdefault',
        'bundle' => 'sys',
        'variablename' => 'New BIOSversion',
        'variablevalue' => 'BIOS version',
        'variabletype' => 'string',
        'comp' => 'newdefault.cfe_autorun_inventory_dmidecode.dmi[bios-version]',
        'metatags' => '{source=promise,inventory,"attribute_name=New BIOS version"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],
    //CPU model
    [
        'hostkey' => $hostKey,
        'namespace' => 'newdefault',
        'bundle' => 'sys',
        'variablename' => 'New CPUmodel',
        'variablevalue' => 'CPU model A' . mt_rand(0, 20),
        'variabletype' => 'string',
        'comp' => 'newdefault.cfe_autorun_inventory_cpuinfo.cpu_model',
        'metatags' => '{source=promise,inventory,"attribute_name=New CPU model"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],
    //System serial number
    [
        'hostkey' => $hostKey,
        'namespace' => 'newdefault',
        'bundle' => 'sys',
        'variablename' => 'New system-serial-number',
        'variablevalue' => 'System serial number ' . mt_rand(0, 20),
        'variabletype' => 'string',
        'comp' => 'newdefault.cfe_autorun_inventory_dmidecode.dmi[system-serial-number]',
        'metatags' => '{source=promise,inventory,"attribute_name=New System serial number"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],
    //System version
    [
        'hostkey' => $hostKey,
        'namespace' => 'newdefault',
        'bundle' => 'Systemversion',
        'variablename' => 'New Systemversion',
        'variablevalue' => 'System manufacturer ' . mt_rand(0, 20),
        'variabletype' => 'string',
        'comp' => 'newdefault.cfe_autorun_inventory_dmidecode.dmi[system-version]',
        'metatags' => '{source=promise,inventory,"attribute_name=New System version"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],

    //Disk free (%)
    [
        'hostkey' => $hostKey,
        'namespace' => 'newdefault',
        'bundle' => 'sys',
        'variablename' => 'New Diskfree',
        'variablevalue' => mt_rand(1, 99),
        'variabletype' => 'int',
        'comp' => 'newdefault.cfe_autorun_inventory_disk.free',
        'metatags' => '{source=promise,inventory,"attribute_name=New Disk free (%)"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],

    //CFEngine ID
    [
        'hostkey' => $hostKey,
        'namespace' => 'newdefault',
        'bundle' => 'sys',
        'variablename' => 'New key_digest',
        'variablevalue' => $hostKey,
        'variabletype' => 'string',
        'comp' => 'newdefault.sys.key_digest',
        'metatags' => '{source=promise,inventory,"attribute_name=New CFEngine ID"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],
    //CFEngine version
    [
        'hostkey' => $hostKey,
        'namespace' => 'newdefault',
        'bundle' => 'sys',
        'variablename' => 'New newdefault.cfe_autorun_inventory_disk.free',
        'variablevalue' => '3.10.' . mt_rand(1, 99),
        'variabletype' => 'string',
        'comp' => 'newdefault.sys.cf_version',
        'metatags' => '{source=promise,inventory,"attribute_name=New CFEngine version"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],

    //Interfaces
    [
        'hostkey' => $hostKey,
        'namespace' => 'newdefault',
        'bundle' => 'sys',
        'variablename' => 'New Interfaces',
        'variablevalue' => '{"pop","imap"}',
        'variabletype' => 'slist',
        'comp' => 'newdefault.sys.interfaces',
        'metatags' => '{source=promise,inventory,"attribute_name=New Interfaces"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],

    //MAC addresses
    [
        'hostkey' => $hostKey,
        'namespace' => 'newdefault',
        'bundle' => 'sys',
        'variablename' => 'New MACaddresses',
        'variablevalue' =>
            '{"' .
            mt_rand(10, 99) .
            '-' .
            mt_rand(10, 99) .
            '-' .
            mt_rand(10, 99) .
            '-' .
            mt_rand(10, 99) .
            '-' .
            mt_rand(10, 99) .
            '-' .
            mt_rand(10, 99) .
            '","' .
            mt_rand(10, 99) .
            '-' .
            mt_rand(10, 99) .
            '-' .
            mt_rand(10, 99) .
            '-' .
            mt_rand(10, 99) .
            '-' .
            mt_rand(10, 99) .
            '-' .
            mt_rand(10, 99) .
            '"}',
        'variabletype' => 'slist',
        'comp' => 'newdefault.sys.hardware_addresses',
        'metatags' => '{source=promise,inventory,"attribute_name=New MAC addresses"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],

    //Ports listening
    [
        'hostkey' => $hostKey,
        'namespace' => 'newdefault',
        'bundle' => 'sys',
        'variablename' => 'New Portslistening',
        'variablevalue' =>
            '{"' .
            mt_rand(10, 10000) .
            '","' .
            mt_rand(10, 10000) .
            '","' .
            mt_rand(10, 10000) .
            '","' .
            mt_rand(10, 10000) .
            '","' .
            mt_rand(10, 10000) .
            '"}',
        'variabletype' => 'slist',
        'comp' => 'newdefault.cfe_autorun_inventory_listening_ports.ports',
        'metatags' => '{source=promise,inventory,"attribute_name=New Ports listening"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],
    //CPU physical cores
    [
        'hostkey' => $hostKey,
        'namespace' => 'newdefault',
        'bundle' => 'sys',
        'variablename' => 'New CPU_physical_cores',
        'variablevalue' => mt_rand(1, 10),
        'variabletype' => 'int',
        'comp' => 'newdefault.cfe_autorun_inventory_cpuinfo.cpuinfo_physical_cores',
        'metatags' => '{source=promise,inventory,"attribute_name=New CPU physical cores"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],
    //CPU sockets
    [
        'hostkey' => $hostKey,
        'namespace' => 'newdefault',
        'bundle' => 'sys',
        'variablename' => 'New CPUSockets',
        'variablevalue' => mt_rand(1, 1000),
        'variabletype' => 'int',
        'comp' => 'newdefault.cfe_autorun_inventory_proc_cpuinfo.cpuinfo_physical_socket_inventory',
        'metatags' => '{source=promise,inventory,"attribute_name=New CPU sockets"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],

    //System product name
    [
        'hostkey' => $hostKey,
        'namespace' => 'newdefault',
        'bundle' => 'sys',
        'variablename' => 'New SystemProductName',
        'variablevalue' => md5(mt_rand(1, 10022222220)),
        'variabletype' => 'string',
        'comp' => 'newdefault.cfe_autorun_inventory_dmidecode.dmi[system-product-name]',
        'metatags' => '{source=promise,inventory,"attribute_name=New System product name"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],

    //Solaris zone
    [
        'hostkey' => $hostKey,
        'namespace' => 'newdefault',
        'bundle' => 'sys',
        'variablename' => 'New solariszone',
        'variablevalue' => md5(mt_rand(1, 10022222220)),
        'variabletype' => 'string',
        'comp' => 'newdefault.cfe_autorun_inventory_dmidecode.solariszone',
        'metatags' => '{source=promise,inventory,"attribute_name=New Solaris zone"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],

    //Windows roles
    [
        'hostkey' => $hostKey,
        'namespace' => 'newdefault',
        'bundle' => 'sys',
        'variablename' => 'New Windowsroles',
        'variablevalue' => md5(mt_rand(1, 10022222220)),
        'variabletype' => 'string',
        'comp' => 'newdefault.cfe_autorun_inventory_dmidecode.Windowsroles',
        'metatags' => '{source=promise,inventory,"attribute_name=New Windows roles"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],

    //Virtual host
    [
        'hostkey' => $hostKey,
        'namespace' => 'newdefault',
        'bundle' => 'sys',
        'variablename' => 'New VirtualHost',
        'variablevalue' => md5(mt_rand(1, 10022222220)),
        'variabletype' => 'string',
        'comp' => 'newdefault.cfe_autorun_inventory_dmidecode.VirtualHost',
        'metatags' => '{source=promise,inventory,"attribute_name=New Virtual host"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],

    //Highest Service Pack
    [
        'hostkey' => $hostKey,
        'namespace' => 'newdefault',
        'bundle' => 'sys',
        'variablename' => 'New HighestServicePack',
        'variablevalue' => md5(mt_rand(1, 10022222220)),
        'variabletype' => 'string',
        'comp' => 'newdefault.cfe_autorun_inventory_dmidecode.HighestServicePack',
        'metatags' => '{source=promise,inventory,"attribute_name=New Highest Service Pack"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],

    //Highest Technology Level
    [
        'hostkey' => $hostKey,
        'namespace' => 'newdefault',
        'bundle' => 'sys',
        'variablename' => 'New HighestTechnologyLevel',
        'variablevalue' => md5(mt_rand(1, 10022222220)),
        'variabletype' => 'string',
        'comp' => 'newdefault.cfe_autorun_inventory_dmidecode.HighestTechnologyLevel',
        'metatags' => '{source=promise,inventory,"attribute_name=New Highest Technology Level"}',
        'changetimestamp' => date('Y-m-d H:i:s+00'),
    ],
];
