<?php

class ReportsImporter extends BaseDataImporter
{
    private $reports = [];
    private $scheduledReports = [];

    public function isOnlyForAdmin(): bool
    {
        return false;
    }

    public function import($data)
    {
        $data = json_decode($data, JSON_OBJECT_AS_ARRAY);
        $this->importReports($data['reports']);
        $this->importScheduledReports($data['scheduled']);
    }

    private function importReports($data)
    {
        foreach ($data as $report) {
            //set current user name in case of non admin user
            $report['username'] = $this->isAdmin === true ? $report['username'] : $this->username;

            $this->db->reset_query();
            $filter = [
                'username' => $report['username'],
                'label' => $report['label'],
            ];
            $exist = $this->db->get_where('report', $filter);

            $oldId = $report['id'];
            unset($report['id']);
            if ($exist->num_rows() == 0) {
                $this->db->insert('report', $report);
                $this->reports[$oldId] = ['id' => $this->db->insert_id()];
            } elseif ($this->skipDuplicates == 0) {
                $this->db->update('report', $report, $filter);
                $this->reports[$oldId] = ['id' => $exist->row()->id];
            } else {
                $this->reports[$oldId] = ['id' => $exist->row()->id];
            }
        }
    }

    private function importScheduledReports($data)
    {
        $cfmpReports = $data['cfmp'];
        $cfmpSettings = $data['cfsettings'];

        foreach ($cfmpReports as $index => $report) {
            //set current user name in case of non admin user
            $report['userid'] = $this->isAdmin === true ? $report['userid'] : $this->username;

            $oldId = $report['id'];
            if (in_array($report['reportid'], array_keys($this->reports))) {
                $report['reportid'] = $this->reports[$report['reportid']]['id'];
                $report['skipmailing'] = boolval($report['skipmailing']) == true ? 't' : 'f';

                $filter = [
                    'reportid' => $report['reportid'],
                    'userid' => $report['userid'],
                    'schedulename' => $report['schedulename'],
                ];

                $exist = $this->db->get_where('report_schedule', $filter);

                if ($exist->num_rows() == 0) {
                    $report['id'] = $report['reportid'] . '_' . $report['userid'] . '_' . time() . $index;
                    $this->db->insert('report_schedule', $report);
                    $this->scheduledReports[$oldId] = ['id' => $report['id'], 'update' => false];
                } elseif ($this->skipDuplicates == 0) {
                    unset($report['id']);
                    $this->db->update('report_schedule', $report, $filter);
                    $this->scheduledReports[$oldId] = ['id' => $exist->row()->id, 'update' => true];
                }
            }
        }

        foreach ($cfmpSettings as $report) {
            //set current user name in case of non admin user
            $report['username'] = $this->isAdmin === true ? $report['username'] : $this->username;

            if (in_array($report['query_id'], array_keys($this->scheduledReports))) {
                $update = $this->scheduledReports[$report['query_id']]['update'];
                $report['already_run'] = boolval($report['already_run']) == true ? 't' : 'f';
                $report['enabled'] = boolval($report['enabled']) == true ? 't' : 'f';

                if ($update == true) {
                    $this->settingsDb->update('scheduledreports', $report, ['query_id' => $report['query_id']]);
                } else {
                    $report['query_id'] = $this->scheduledReports[$report['query_id']]['id'];
                    $this->settingsDb->insert('scheduledreports', $report);
                }
            }
        }
    }
}
