/*jslint node: true */
/*jslint browser: true*/
/*jslint nomen: true*/
/*jslint es5: true */
/*global Class, MP_SITE_URL, angular*/
'use strict';

/*
 * Service for rules
 *
 **/


var RulesServiceClass = Class.extend({
        RULESAPI_URL: MP_SITE_URL + '/dashboard/rulesapi',
        getrules: function (rulesList) {
            var url, urlParams;
            url = this.RULESAPI_URL + '/rules/';
            urlParams = '';

            // encode parameter as array
            if (rulesList) {
                if (rulesList instanceof Array) {
                    urlParams = rulesList.join(',');
                } else {
                    urlParams = rulesList;
                }

                url += encodeURIComponent(urlParams);
            }

            return this.$http.get(url, {cache: false});
        },

        getRulesByExportIds: function (exportIds) {
            return this.$http.post(this.RULESAPI_URL + '/rules_by_export_ids', {exportIds}, {cache: false});
        },

        saverule: function (ruleObj) {
            var url = this.RULESAPI_URL + '/saverule/';

            //TODO:
            // ask: should we keep previous alert results (hosts count, percentage, fails etc) if we update alert ?
            if (ruleObj.id) {
                url += encodeURIComponent(ruleObj.id);
            }

            return this.$http.post(url, ruleObj, {cache: false});
        },


    validateCustomSql: function (sql) {
        var url = this.RULESAPI_URL + '/validatecustomsql';
        return this.$http.post(url, {"sql": sql}, {cache: false});
    },



    deleterule: function (alertId) {
            var self = this;
            var url = this.RULESAPI_URL + '/deleterule/' + encodeURIComponent(alertId);
            return this.$http['delete'](url, {cache: false}).then(
                function(data) {
                    return data.data;
                },
                function(data) {
                    self.$rootScope.$broadcast('deleteRule_Fail_Event', data.data);
                }
            );
        },
    getStats: function (id, data) {
        const url = this.RULESAPI_URL + '/statistics/' + encodeURIComponent(id);
        return this.$http.post(url, data, {cache: false});
    },
    getAllStats: function (ids, data) {
        const url = this.RULESAPI_URL + '/batch_statistics/' ;
        return this.$http.post(url, {...data, ids}, {cache: false});
    }
    });

(function () {
    var rulesServiceProvider = Class.extend({
        instance: new RulesServiceClass(),
        $get: ['$http', '$rootScope', function ($http, $rootScope) {
            this.instance.$http = $http;
            this.instance.$rootScope = $rootScope;
            return this.instance;
        }]
    });

    angular.module('rulesServiceModule', [])
        .provider('rulesService', rulesServiceProvider);
}());